/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.net.packet;

import com.google.common.base.MoreObjects;
import java.util.Objects;
import java.util.Optional;
import org.onosproject.cluster.NodeId;
import org.onosproject.core.ApplicationId;
import org.onosproject.net.DeviceId;
import org.onosproject.net.flow.TrafficSelector;
import org.onosproject.net.packet.PacketPriority;
import org.onosproject.net.packet.PacketRequest;

public final class DefaultPacketRequest
implements PacketRequest {
    private final TrafficSelector selector;
    private final PacketPriority priority;
    private final ApplicationId appId;
    private final NodeId nodeId;
    private final Optional<DeviceId> deviceId;

    public DefaultPacketRequest(TrafficSelector selector, PacketPriority priority, ApplicationId appId, NodeId nodeId, Optional<DeviceId> deviceId) {
        this.selector = selector;
        this.priority = priority;
        this.appId = appId;
        this.nodeId = nodeId;
        this.deviceId = deviceId;
    }

    @Override
    public TrafficSelector selector() {
        return this.selector;
    }

    @Override
    public PacketPriority priority() {
        return this.priority;
    }

    @Override
    public ApplicationId appId() {
        return this.appId;
    }

    @Override
    public Optional<DeviceId> deviceId() {
        return this.deviceId;
    }

    @Override
    public NodeId nodeId() {
        return this.nodeId;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.selector, this.priority, this.appId, this.nodeId, this.deviceId});
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        DefaultPacketRequest other = (DefaultPacketRequest)obj;
        return Objects.equals(this.selector, other.selector) && Objects.equals((Object)this.priority, (Object)other.priority) && Objects.equals(this.appId, other.appId) && Objects.equals(this.nodeId, other.nodeId) && Objects.equals(this.deviceId, other.deviceId);
    }

    public String toString() {
        return MoreObjects.toStringHelper(this.getClass()).add("selector", (Object)this.selector).add("priority", (Object)this.priority).add("appId", (Object)this.appId).add("nodeId", (Object)this.nodeId).add("applies to", (Object)this.deviceId.map(DeviceId::toString).orElse("all")).toString();
    }
}

