/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.net.pi.runtime;

import com.google.common.annotations.Beta;
import com.google.common.base.MoreObjects;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import java.util.Collection;
import java.util.Set;
import org.onosproject.net.pi.runtime.PiEntityType;
import org.onosproject.net.pi.runtime.PiPreEntry;
import org.onosproject.net.pi.runtime.PiPreReplica;

@Beta
public final class PiMulticastGroupEntry
implements PiPreEntry {
    private final long groupId;
    private final Set<PiPreReplica> replicas;

    private PiMulticastGroupEntry(long groupId, Set<PiPreReplica> replicas) {
        this.groupId = groupId;
        this.replicas = replicas;
    }

    public long groupId() {
        return this.groupId;
    }

    public Set<PiPreReplica> replicas() {
        return this.replicas;
    }

    @Override
    public PiPreEntry.PiPreEntryType preEntryType() {
        return PiPreEntry.PiPreEntryType.MULTICAST_GROUP;
    }

    @Override
    public PiEntityType piEntityType() {
        return PiEntityType.PRE_MULTICAST_GROUP_ENTRY;
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.groupId, this.replicas});
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        PiMulticastGroupEntry other = (PiMulticastGroupEntry)obj;
        return Objects.equal((Object)this.groupId, (Object)other.groupId) && Objects.equal(this.replicas, other.replicas);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("groupId", this.groupId).add("replicas", this.replicas).toString();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private Long groupId;
        private ImmutableSet.Builder<PiPreReplica> replicaSetBuilder = ImmutableSet.builder();

        private Builder() {
        }

        public Builder withGroupId(long groupId) {
            this.groupId = groupId;
            return this;
        }

        public Builder addReplica(PiPreReplica replica) {
            Preconditions.checkNotNull((Object)replica);
            this.replicaSetBuilder.add((Object)replica);
            return this;
        }

        public Builder addReplicas(Collection<PiPreReplica> replicas) {
            Preconditions.checkNotNull(replicas);
            this.replicaSetBuilder.addAll(replicas);
            return this;
        }

        public PiMulticastGroupEntry build() {
            Preconditions.checkNotNull((Object)this.groupId, (Object)"Multicast group ID must be set");
            ImmutableSet replicas = this.replicaSetBuilder.build();
            Preconditions.checkArgument((!replicas.isEmpty() ? 1 : 0) != 0, (Object)"At least one replica must be defined");
            return new PiMulticastGroupEntry(this.groupId, (Set)replicas);
        }
    }
}

