/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.net.behaviour;

import com.google.common.testing.EqualsTester;
import com.spotify.hamcrest.optional.OptionalMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Test;
import org.onlab.junit.ImmutableClassChecker;
import org.onosproject.net.behaviour.DefaultPatchDescription;
import org.onosproject.net.behaviour.PatchDescription;

public class DefaultPatchDescriptionTest {
    private String deviceId1 = "d1";
    private String ifaceName1 = "i1";
    private String peerName1 = "p1";
    private PatchDescription defaultPatchDescription1 = DefaultPatchDescription.builder().deviceId(this.deviceId1).ifaceName(this.ifaceName1).peer(this.peerName1).build();
    private PatchDescription sameAsDefaultPatchDescription1 = DefaultPatchDescription.builder().deviceId(this.deviceId1).ifaceName(this.ifaceName1).peer(this.peerName1).build();
    private PatchDescription defaultPatchDescription2 = DefaultPatchDescription.builder().deviceId(this.deviceId1 + "2").ifaceName(this.ifaceName1).peer(this.peerName1).build();
    private PatchDescription defaultPatchDescription3 = DefaultPatchDescription.builder().deviceId(this.deviceId1).ifaceName(this.ifaceName1 + "2").peer(this.peerName1).build();
    private PatchDescription defaultPatchDescription4 = DefaultPatchDescription.builder().deviceId(this.deviceId1).ifaceName(this.ifaceName1).peer(this.peerName1 + "2").build();
    private PatchDescription defaultPatchDescriptionNoDeviceId = DefaultPatchDescription.builder().ifaceName(this.ifaceName1).peer(this.peerName1 + "2").build();

    @Test
    public void testImmutability() {
        ImmutableClassChecker.assertThatClassIsImmutable(DefaultPatchDescription.class);
    }

    @Test
    public void testConstruction() {
        MatcherAssert.assertThat((Object)this.defaultPatchDescription1.deviceId(), (Matcher)OptionalMatchers.optionalWithValue((Matcher)Matchers.is((Object)this.deviceId1)));
        MatcherAssert.assertThat((Object)this.defaultPatchDescription1.ifaceName(), (Matcher)Matchers.is((Object)this.ifaceName1));
        MatcherAssert.assertThat((Object)this.defaultPatchDescription1.peer(), (Matcher)Matchers.is((Object)this.peerName1));
    }

    @Test
    public void testEquals() {
        new EqualsTester().addEqualityGroup(new Object[]{this.defaultPatchDescription1, this.sameAsDefaultPatchDescription1}).addEqualityGroup(new Object[]{this.defaultPatchDescription2}).addEqualityGroup(new Object[]{this.defaultPatchDescription3}).addEqualityGroup(new Object[]{this.defaultPatchDescription4}).addEqualityGroup(new Object[]{this.defaultPatchDescriptionNoDeviceId}).testEquals();
    }
}

