/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.ui.topo;

import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import org.junit.Assert;
import org.junit.Test;
import org.onosproject.ui.JsonUtils;
import org.onosproject.ui.topo.DeviceHighlight;
import org.onosproject.ui.topo.Highlights;
import org.onosproject.ui.topo.NodeBadge;
import org.onosproject.ui.topo.TopoJson;

public class TopoJsonTest {
    private static final String DEV1 = "device-1";
    private static final String DEV2 = "device-2";
    private static final String SOME_MSG = "Hello there";
    private static final String GID = "glyph-ID";
    private ObjectNode payload;

    private void checkArrayLength(String key, int expLen) {
        ArrayNode a = (ArrayNode)this.payload.get(key);
        Assert.assertEquals((String)("wrong size: " + key), (long)expLen, (long)a.size());
    }

    private void checkEmptyArrays() {
        this.checkArrayLength("devices", 0);
        this.checkArrayLength("hosts", 0);
        this.checkArrayLength("links", 0);
    }

    @Test
    public void basicHighlights() {
        Highlights h = new Highlights();
        this.payload = TopoJson.json((Highlights)h);
        this.checkEmptyArrays();
        String subdue = JsonUtils.string((ObjectNode)this.payload, (String)"subdue");
        Assert.assertEquals((String)"subdue", (Object)"", (Object)subdue);
    }

    @Test
    public void subdueMinimalHighlights() {
        Highlights h = new Highlights().subdueAllElse(Highlights.Amount.MINIMALLY);
        this.payload = TopoJson.json((Highlights)h);
        this.checkEmptyArrays();
        String subdue = JsonUtils.string((ObjectNode)this.payload, (String)"subdue");
        Assert.assertEquals((String)"not min", (Object)"min", (Object)subdue);
    }

    @Test
    public void subdueMaximalHighlights() {
        Highlights h = new Highlights().subdueAllElse(Highlights.Amount.MAXIMALLY);
        this.payload = TopoJson.json((Highlights)h);
        this.checkEmptyArrays();
        String subdue = JsonUtils.string((ObjectNode)this.payload, (String)"subdue");
        Assert.assertEquals((String)"not max", (Object)"max", (Object)subdue);
    }

    @Test
    public void badgedDevice() {
        Highlights h = new Highlights();
        DeviceHighlight dh = new DeviceHighlight(DEV1);
        dh.setBadge(NodeBadge.number((int)7));
        h.add(dh);
        dh = new DeviceHighlight(DEV2);
        dh.setBadge(NodeBadge.glyph((NodeBadge.Status)NodeBadge.Status.WARN, (String)GID, (String)SOME_MSG));
        h.add(dh);
        this.payload = TopoJson.json((Highlights)h);
        ArrayNode a = (ArrayNode)this.payload.get("devices");
        ObjectNode d = (ObjectNode)a.get(0);
        Assert.assertEquals((String)"wrong device id", (Object)DEV1, (Object)d.get("id").asText());
        ObjectNode b = (ObjectNode)d.get("badge");
        Assert.assertNotNull((String)"missing badge", (Object)b);
        Assert.assertEquals((String)"wrong status code", (Object)"i", (Object)b.get("status").asText());
        Assert.assertEquals((String)"wrong text", (Object)"7", (Object)b.get("txt").asText());
        Assert.assertNull((String)"glyph?", (Object)b.get("gid"));
        Assert.assertNull((String)"msg?", (Object)b.get("msg"));
        d = (ObjectNode)a.get(1);
        Assert.assertEquals((String)"wrong device id", (Object)DEV2, (Object)d.get("id").asText());
        b = (ObjectNode)d.get("badge");
        Assert.assertNotNull((String)"missing badge", (Object)b);
        Assert.assertEquals((String)"wrong status code", (Object)"w", (Object)b.get("status").asText());
        Assert.assertNull((String)"text?", (Object)b.get("txt"));
        Assert.assertEquals((String)"wrong text", (Object)GID, (Object)b.get("gid").asText());
        Assert.assertEquals((String)"wrong message", (Object)SOME_MSG, (Object)b.get("msg").asText());
    }
}

