/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.net.device;

import com.google.common.base.MoreObjects;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import java.net.URI;
import org.onlab.packet.ChassisId;
import org.onosproject.net.AbstractDescription;
import org.onosproject.net.Device;
import org.onosproject.net.SparseAnnotations;
import org.onosproject.net.device.DeviceDescription;

public class DefaultDeviceDescription
extends AbstractDescription
implements DeviceDescription {
    private static final int MANUFACTURER_MAX_LENGTH = 256;
    private static final int HW_VERSION_MAX_LENGTH = 256;
    private static final int SW_VERSION_MAX_LENGTH = 256;
    private static final int SERIAL_NUMBER_MAX_LENGTH = 256;
    private final URI uri;
    private final Device.Type type;
    private final String manufacturer;
    private final String hwVersion;
    private final String swVersion;
    private final String serialNumber;
    private final ChassisId chassisId;
    private final boolean defaultAvailable;

    public DefaultDeviceDescription(URI uri, Device.Type type, String manufacturer, String hwVersion, String swVersion, String serialNumber, ChassisId chassis, SparseAnnotations ... annotations) {
        this(uri, type, manufacturer, hwVersion, swVersion, serialNumber, chassis, true, annotations);
    }

    public DefaultDeviceDescription(URI uri, Device.Type type, String manufacturer, String hwVersion, String swVersion, String serialNumber, ChassisId chassis, boolean defaultAvailable, SparseAnnotations ... annotations) {
        super(annotations);
        this.uri = (URI)Preconditions.checkNotNull((Object)uri, (Object)"Device URI cannot be null");
        this.type = (Device.Type)((Object)Preconditions.checkNotNull((Object)((Object)type), (Object)"Device type cannot be null"));
        if (hwVersion != null) {
            Preconditions.checkArgument((hwVersion.length() <= 256 ? 1 : 0) != 0, (Object)"hwVersion exceeds maximum length 256");
        }
        if (swVersion != null) {
            Preconditions.checkArgument((swVersion.length() <= 256 ? 1 : 0) != 0, (Object)"swVersion exceeds maximum length 256");
        }
        if (manufacturer != null) {
            Preconditions.checkArgument((manufacturer.length() <= 256 ? 1 : 0) != 0, (Object)"manufacturer exceeds maximum length 256");
        }
        if (serialNumber != null) {
            Preconditions.checkArgument((serialNumber.length() <= 256 ? 1 : 0) != 0, (Object)"serialNumber exceeds maximum length 256");
        }
        this.manufacturer = manufacturer;
        this.hwVersion = hwVersion;
        this.swVersion = swVersion;
        this.serialNumber = serialNumber;
        this.chassisId = chassis;
        this.defaultAvailable = defaultAvailable;
    }

    public DefaultDeviceDescription(DeviceDescription base, SparseAnnotations ... annotations) {
        this(base.deviceUri(), base.type(), base.manufacturer(), base.hwVersion(), base.swVersion(), base.serialNumber(), base.chassisId(), base.isDefaultAvailable(), annotations);
    }

    public DefaultDeviceDescription(DeviceDescription base, Device.Type type, SparseAnnotations ... annotations) {
        this(base.deviceUri(), type, base.manufacturer(), base.hwVersion(), base.swVersion(), base.serialNumber(), base.chassisId(), base.isDefaultAvailable(), annotations);
    }

    public DefaultDeviceDescription(DeviceDescription base, boolean defaultAvailable, SparseAnnotations ... annotations) {
        this(base.deviceUri(), base.type(), base.manufacturer(), base.hwVersion(), base.swVersion(), base.serialNumber(), base.chassisId(), defaultAvailable, annotations);
    }

    public static DefaultDeviceDescription copyReplacingAnnotation(DeviceDescription base, SparseAnnotations annotations) {
        return new DefaultDeviceDescription(base, annotations);
    }

    @Override
    public URI deviceUri() {
        return this.uri;
    }

    @Override
    public Device.Type type() {
        return this.type;
    }

    @Override
    public String manufacturer() {
        return this.manufacturer;
    }

    @Override
    public String hwVersion() {
        return this.hwVersion;
    }

    @Override
    public String swVersion() {
        return this.swVersion;
    }

    @Override
    public String serialNumber() {
        return this.serialNumber;
    }

    @Override
    public ChassisId chassisId() {
        return this.chassisId;
    }

    @Override
    public boolean isDefaultAvailable() {
        return this.defaultAvailable;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("uri", (Object)this.uri).add("type", (Object)this.type).add("mfr", (Object)this.manufacturer).add("hw", (Object)this.hwVersion).add("sw", (Object)this.swVersion).add("serial", (Object)this.serialNumber).add("annotations", (Object)this.annotations()).toString();
    }

    @Override
    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{super.hashCode(), this.uri, this.type, this.manufacturer, this.hwVersion, this.swVersion, this.serialNumber, this.chassisId, this.defaultAvailable});
    }

    @Override
    public boolean equals(Object object) {
        if (object instanceof DefaultDeviceDescription) {
            if (!super.equals(object)) {
                return false;
            }
            DefaultDeviceDescription that = (DefaultDeviceDescription)object;
            return Objects.equal((Object)this.uri, (Object)that.uri) && Objects.equal((Object)((Object)this.type), (Object)((Object)that.type)) && Objects.equal((Object)this.manufacturer, (Object)that.manufacturer) && Objects.equal((Object)this.hwVersion, (Object)that.hwVersion) && Objects.equal((Object)this.swVersion, (Object)that.swVersion) && Objects.equal((Object)this.serialNumber, (Object)that.serialNumber) && Objects.equal((Object)this.chassisId, (Object)that.chassisId) && Objects.equal((Object)this.defaultAvailable, (Object)that.defaultAvailable);
        }
        return false;
    }

    DefaultDeviceDescription() {
        this.uri = null;
        this.type = null;
        this.manufacturer = null;
        this.hwVersion = null;
        this.swVersion = null;
        this.serialNumber = null;
        this.chassisId = null;
        this.defaultAvailable = true;
    }
}

