/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.net.driver;

import org.apache.felix.scr.annotations.Activate;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Deactivate;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.ReferenceCardinality;
import org.onosproject.net.driver.DriverAdminService;
import org.onosproject.net.driver.DriverProvider;
import org.onosproject.net.driver.DriverResolver;
import org.onosproject.net.driver.XmlDriverLoader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component
public abstract class AbstractIndependentDriverLoader {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private DriverProvider provider;
    private final String path;
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected DriverAdminService driverAdminService;

    protected AbstractIndependentDriverLoader(String path) {
        this.path = path;
    }

    @Activate
    protected void activate() {
        try {
            this.provider = new XmlDriverLoader(this.getClass().getClassLoader(), this.driverAdminService).loadDrivers(this.getClass().getResourceAsStream(this.path), (DriverResolver)this.driverAdminService);
            this.driverAdminService.registerProvider(this.provider);
        }
        catch (Exception e) {
            this.log.error("Unable to load {} driver definitions", (Object)this.path, (Object)e);
        }
        this.log.info("Started");
    }

    @Deactivate
    protected void deactivate() {
        this.driverAdminService.unregisterProvider(this.provider);
        this.log.info("Stopped");
    }

    protected void bindDriverAdminService(DriverAdminService driverAdminService) {
        this.driverAdminService = driverAdminService;
    }

    protected void unbindDriverAdminService(DriverAdminService driverAdminService) {
        if (this.driverAdminService == driverAdminService) {
            this.driverAdminService = null;
        }
    }
}

