/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.cluster;

import com.google.common.collect.ImmutableSet;
import com.google.common.testing.EqualsTester;
import java.util.Set;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Test;
import org.onlab.packet.IpAddress;
import org.onosproject.cluster.ClusterMetadata;
import org.onosproject.cluster.ControllerNode;
import org.onosproject.cluster.DefaultControllerNode;
import org.onosproject.cluster.Node;
import org.onosproject.cluster.NodeId;
import org.onosproject.net.provider.ProviderId;

public class ClusterMetadataTest {
    private final NodeId nid1 = NodeId.nodeId((String)"10.0.0.1");
    private final NodeId nid2 = NodeId.nodeId((String)"10.0.0.2");
    private final ControllerNode n1 = new DefaultControllerNode(this.nid1, IpAddress.valueOf((String)"10.0.0.1"), 9876);
    private final ControllerNode n2 = new DefaultControllerNode(this.nid2, IpAddress.valueOf((String)"10.0.0.2"), 9876);
    private final ClusterMetadata metadata1 = new ClusterMetadata("foo", this.n1, (Set)ImmutableSet.of(), (Set)ImmutableSet.of((Object)this.n1));
    private final ClusterMetadata sameAsMetadata1 = new ClusterMetadata("foo", this.n1, (Set)ImmutableSet.of(), (Set)ImmutableSet.of((Object)this.n1));
    private final ClusterMetadata metadata2 = new ClusterMetadata("bar", this.n1, (Set)ImmutableSet.of((Object)this.n1), (Set)ImmutableSet.of((Object)this.n1, (Object)this.n2));
    private final ProviderId defaultProvider = new ProviderId("none", "none");

    @Test
    public void checkEquals() {
        new EqualsTester().addEqualityGroup(new Object[]{this.metadata1, this.sameAsMetadata1}).addEqualityGroup(new Object[]{this.metadata2}).testEquals();
    }

    @Test
    public void checkConstruction() {
        Assert.assertThat((Object)this.metadata2.getName(), (Matcher)Matchers.is((Object)"bar"));
        Assert.assertThat((Object)this.metadata2.getControllerNodes(), (Matcher)Matchers.hasSize((int)1));
        Assert.assertThat((Object)this.metadata2.getControllerNodes(), (Matcher)Matchers.contains((Object[])new ControllerNode[]{this.n1}));
        Assert.assertThat((Object)this.metadata2.getStorageNodes(), (Matcher)Matchers.hasSize((int)2));
        Assert.assertThat((Object)this.metadata2.getStorageNodes(), (Matcher)Matchers.contains((Object[])new Node[]{this.n1, this.n2}));
        Assert.assertThat((Object)this.metadata1.providerId(), (Matcher)Matchers.is((Object)this.defaultProvider));
    }
}

