/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.net;

import com.google.common.collect.ImmutableSet;
import org.junit.Assert;
import org.junit.Test;
import org.onosproject.net.DefaultAnnotations;
import org.onosproject.net.SparseAnnotations;

public class DefaultAnnotationsTest {
    private DefaultAnnotations annotations;

    @Test
    public void basics() {
        this.annotations = DefaultAnnotations.builder().set("foo", "1").set("bar", "2").build();
        Assert.assertEquals((String)"incorrect keys", (Object)ImmutableSet.of((Object)"foo", (Object)"bar"), (Object)this.annotations.keys());
        Assert.assertEquals((String)"incorrect value", (Object)"1", (Object)this.annotations.value("foo"));
        Assert.assertEquals((String)"incorrect value", (Object)"2", (Object)this.annotations.value("bar"));
    }

    @Test
    public void empty() {
        this.annotations = DefaultAnnotations.builder().build();
        Assert.assertTrue((String)"incorrect keys", (boolean)this.annotations.keys().isEmpty());
    }

    @Test
    public void remove() {
        this.annotations = DefaultAnnotations.builder().remove("foo").set("bar", "2").build();
        Assert.assertEquals((String)"incorrect keys", (Object)ImmutableSet.of((Object)"foo", (Object)"bar"), (Object)this.annotations.keys());
        Assert.assertNull((String)"incorrect value", (Object)this.annotations.value("foo"));
        Assert.assertEquals((String)"incorrect value", (Object)"2", (Object)this.annotations.value("bar"));
    }

    @Test
    public void union() {
        this.annotations = DefaultAnnotations.builder().set("foo", "1").set("bar", "2").remove("buz").build();
        Assert.assertEquals((String)"incorrect keys", (Object)ImmutableSet.of((Object)"foo", (Object)"bar", (Object)"buz"), (Object)this.annotations.keys());
        DefaultAnnotations updates = DefaultAnnotations.builder().remove("foo").set("bar", "3").set("goo", "4").remove("fuzz").build();
        SparseAnnotations result = DefaultAnnotations.union((SparseAnnotations)this.annotations, (SparseAnnotations)updates);
        Assert.assertTrue((String)"remove instruction in original remains", (boolean)result.isRemoved("buz"));
        Assert.assertTrue((String)"remove instruction in update remains", (boolean)result.isRemoved("fuzz"));
        Assert.assertEquals((String)"incorrect keys", (Object)ImmutableSet.of((Object)"buz", (Object)"goo", (Object)"bar", (Object)"fuzz"), (Object)result.keys());
        Assert.assertNull((String)"incorrect value", (Object)result.value("foo"));
        Assert.assertEquals((String)"incorrect value", (Object)"3", (Object)result.value("bar"));
        Assert.assertEquals((String)"incorrect value", (Object)"4", (Object)result.value("goo"));
    }

    @Test
    public void merge() {
        this.annotations = DefaultAnnotations.builder().set("foo", "1").set("bar", "2").build();
        Assert.assertEquals((String)"incorrect keys", (Object)ImmutableSet.of((Object)"foo", (Object)"bar"), (Object)this.annotations.keys());
        DefaultAnnotations updates = DefaultAnnotations.builder().remove("foo").set("bar", "3").set("goo", "4").build();
        this.annotations = DefaultAnnotations.merge((DefaultAnnotations)this.annotations, (SparseAnnotations)updates);
        Assert.assertEquals((String)"incorrect keys", (Object)ImmutableSet.of((Object)"goo", (Object)"bar"), (Object)this.annotations.keys());
        Assert.assertNull((String)"incorrect value", (Object)this.annotations.value("foo"));
        Assert.assertEquals((String)"incorrect value", (Object)"3", (Object)this.annotations.value("bar"));
    }

    @Test
    public void noopMerge() {
        this.annotations = DefaultAnnotations.builder().set("foo", "1").set("bar", "2").build();
        Assert.assertEquals((String)"incorrect keys", (Object)ImmutableSet.of((Object)"foo", (Object)"bar"), (Object)this.annotations.keys());
        DefaultAnnotations updates = DefaultAnnotations.builder().build();
        Assert.assertSame((String)"same annotations expected", (Object)this.annotations, (Object)DefaultAnnotations.merge((DefaultAnnotations)this.annotations, (SparseAnnotations)updates));
        Assert.assertSame((String)"same annotations expected", (Object)this.annotations, (Object)DefaultAnnotations.merge((DefaultAnnotations)this.annotations, null));
    }

    @Test(expected=NullPointerException.class)
    public void badMerge() {
        DefaultAnnotations.merge(null, null);
    }
}

