/*
 * Copyright 2017-present Open Networking Foundation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.onosproject.net.pi.model;

import com.google.common.annotations.Beta;

/**
 * Type of packet operation in a protocol-independent pipeline.
 */
@Beta
public enum PiPacketOperationType {

    /**
     * Represents a packet-out, i.e. a packet generated by the control plane, optionally encapsulated with control
     * information and sent through a network device port.
     */
    PACKET_OUT,

    /**
     * Represents a packet-in, i.e. a packet originated at the data plane, optionally encapsulated with control
     * information and sent to the controller for further inspection.
     */
    PACKET_IN,
}
