/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.net.intent;

import org.junit.Assert;
import org.junit.Test;
import org.onlab.junit.ImmutableClassChecker;
import org.onosproject.net.FilteredConnectPoint;
import org.onosproject.net.intent.ConnectivityIntentTest;
import org.onosproject.net.intent.PointToPointIntent;

public class PointToPointIntentTest
extends ConnectivityIntentTest {
    @Test
    public void checkImmutability() {
        ImmutableClassChecker.assertThatClassIsImmutableBaseClass(PointToPointIntent.class);
    }

    @Test
    public void basics() {
        PointToPointIntent intent = this.createOne();
        Assert.assertEquals((String)"incorrect id", (Object)APPID, (Object)intent.appId());
        Assert.assertEquals((String)"incorrect match", (Object)MATCH, (Object)intent.selector());
        Assert.assertEquals((String)"incorrect ingress", (Object)P1, (Object)intent.filteredIngressPoint().connectPoint());
        Assert.assertEquals((String)"incorrect egress", (Object)P2, (Object)intent.filteredEgressPoint().connectPoint());
        intent = this.createWithResourceGroup();
        Assert.assertEquals((String)"incorrect id", (Object)APPID, (Object)intent.appId());
        Assert.assertEquals((String)"incorrect match", (Object)MATCH, (Object)intent.selector());
        Assert.assertEquals((String)"incorrect ingress", (Object)P1, (Object)intent.filteredIngressPoint().connectPoint());
        Assert.assertEquals((String)"incorrect egress", (Object)P2, (Object)intent.filteredEgressPoint().connectPoint());
        Assert.assertEquals((String)"incorrect resource group", (Object)RESOURCE_GROUP, (Object)intent.resourceGroup());
    }

    @Test
    public void filtered() {
        PointToPointIntent intent = this.createOneFiltered();
        Assert.assertEquals((String)"incorrect id", (Object)APPID, (Object)intent.appId());
        Assert.assertEquals((String)"incorrect match", (Object)MATCH, (Object)intent.selector());
        Assert.assertEquals((String)"incorrect ingress", (Object)FP1, (Object)intent.filteredIngressPoint());
        Assert.assertEquals((String)"incorrect egress", (Object)FP2, (Object)intent.filteredEgressPoint());
    }

    protected PointToPointIntent createOne() {
        return PointToPointIntent.builder().appId(APPID).selector(MATCH).treatment(NOP).filteredIngressPoint(new FilteredConnectPoint(P1)).filteredEgressPoint(new FilteredConnectPoint(P2)).build();
    }

    protected PointToPointIntent createWithResourceGroup() {
        return PointToPointIntent.builder().appId(APPID).selector(MATCH).treatment(NOP).filteredIngressPoint(new FilteredConnectPoint(P1)).filteredEgressPoint(new FilteredConnectPoint(P2)).resourceGroup(RESOURCE_GROUP).build();
    }

    protected PointToPointIntent createAnother() {
        return PointToPointIntent.builder().appId(APPID).selector(MATCH).treatment(NOP).filteredIngressPoint(new FilteredConnectPoint(P2)).filteredEgressPoint(new FilteredConnectPoint(P1)).build();
    }

    protected PointToPointIntent createOneFiltered() {
        return PointToPointIntent.builder().appId(APPID).selector(MATCH).treatment(NOP).filteredIngressPoint(FP1).filteredEgressPoint(FP2).build();
    }
}

