/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.store.primitives;

import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import org.onosproject.store.service.AsyncAtomicCounterMap;

public class AsyncAtomicCounterMapAdapter<K>
implements AsyncAtomicCounterMap<K> {
    private Map<K, Long> map = new HashMap<K, Long>();

    public CompletableFuture<Long> incrementAndGet(K key) {
        Long value = this.map.getOrDefault(key, 0L) + 1L;
        this.map.put(key, value);
        return CompletableFuture.completedFuture(value);
    }

    public CompletableFuture<Long> decrementAndGet(K key) {
        Long value = this.map.getOrDefault(key, 0L) - 1L;
        this.map.put(key, value);
        return CompletableFuture.completedFuture(value);
    }

    public CompletableFuture<Long> getAndIncrement(K key) {
        Long value = this.map.getOrDefault(key, 0L);
        this.map.put(key, value + 1L);
        return CompletableFuture.completedFuture(value);
    }

    public CompletableFuture<Long> getAndDecrement(K key) {
        Long value = this.map.getOrDefault(key, 0L);
        this.map.put(key, value - 1L);
        return CompletableFuture.completedFuture(value);
    }

    public CompletableFuture<Long> addAndGet(K key, long delta) {
        Long value = this.map.getOrDefault(key, 0L) + delta;
        this.map.put(key, value);
        return CompletableFuture.completedFuture(value);
    }

    public CompletableFuture<Long> getAndAdd(K key, long delta) {
        Long value = this.map.getOrDefault(key, 0L);
        this.map.put(key, value + delta);
        return CompletableFuture.completedFuture(value);
    }

    public CompletableFuture<Long> get(K key) {
        Long value = this.map.getOrDefault(key, 0L);
        return CompletableFuture.completedFuture(value);
    }

    public CompletableFuture<Long> put(K key, long newValue) {
        Long value = this.map.getOrDefault(key, 0L);
        this.map.put(key, newValue);
        return CompletableFuture.completedFuture(value);
    }

    public CompletableFuture<Long> putIfAbsent(K key, long newValue) {
        Long value = this.map.putIfAbsent(key, newValue);
        if (value == null) {
            value = 0L;
        }
        return CompletableFuture.completedFuture(value);
    }

    public CompletableFuture<Boolean> replace(K key, long expectedOldValue, long newValue) {
        boolean value = this.map.replace(key, expectedOldValue, newValue);
        return CompletableFuture.completedFuture(value);
    }

    public CompletableFuture<Long> remove(K key) {
        Long value = this.map.remove(key);
        return CompletableFuture.completedFuture(value);
    }

    public CompletableFuture<Boolean> remove(K key, long value) {
        boolean result = this.map.remove(key, value);
        return CompletableFuture.completedFuture(result);
    }

    public CompletableFuture<Integer> size() {
        int value = this.map.size();
        return CompletableFuture.completedFuture(value);
    }

    public CompletableFuture<Boolean> isEmpty() {
        boolean value = this.map.isEmpty();
        return CompletableFuture.completedFuture(value);
    }

    public CompletableFuture<Void> clear() {
        this.map.clear();
        return CompletableFuture.completedFuture(null);
    }

    public String name() {
        return null;
    }
}

