/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.net.behaviour.trafficcontrol;

import com.google.common.annotations.Beta;
import com.google.common.base.MoreObjects;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import org.onosproject.net.behaviour.trafficcontrol.TokenBucket;
import org.onosproject.net.behaviour.trafficcontrol.TokenBucketEntry;

@Beta
public final class DefaultTokenBucket
implements TokenBucket,
TokenBucketEntry {
    private final long rate;
    private final long burstSize;
    private final TokenBucket.Action action;
    private final short dscp;
    private final TokenBucket.Type type;
    private long processedPackets;
    private long processedBytes;

    private DefaultTokenBucket(long r, long bS, TokenBucket.Action a, short d, TokenBucket.Type t) {
        this.rate = r;
        this.burstSize = bS;
        this.action = a;
        this.dscp = d;
        this.type = t;
    }

    @Override
    public long rate() {
        return this.rate;
    }

    @Override
    public long burstSize() {
        return this.burstSize;
    }

    @Override
    public TokenBucket.Action action() {
        return this.action;
    }

    @Override
    public short dscp() {
        return this.dscp;
    }

    @Override
    public TokenBucket.Type type() {
        return this.type;
    }

    @Override
    public long processedPackets() {
        return this.processedPackets;
    }

    @Override
    public void setProcessedPackets(long packets) {
        this.processedPackets = packets;
    }

    @Override
    public long processedBytes() {
        return this.processedBytes;
    }

    @Override
    public void setProcessedBytes(long bytes) {
        this.processedBytes = bytes;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("rate", this.rate()).add("burstSize", this.burstSize()).add("action", (Object)this.action()).add("dscp", (int)this.dscp()).add("type", (Object)this.type()).toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DefaultTokenBucket that = (DefaultTokenBucket)o;
        return this.rate == that.rate && this.burstSize == that.burstSize && Objects.equal((Object)((Object)this.action), (Object)((Object)that.action)) && this.dscp == that.dscp && Objects.equal((Object)((Object)this.type), (Object)((Object)that.type));
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.rate, this.burstSize, this.action, this.dscp, this.type});
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder
    implements TokenBucket.Builder {
        private long rate;
        private long burstSize = 3000L;
        private TokenBucket.Action action;
        private short dscp;
        private TokenBucket.Type type;

        @Override
        public TokenBucket.Builder withRate(long r) {
            this.rate = r;
            return this;
        }

        @Override
        public TokenBucket.Builder withBurstSize(long bS) {
            this.burstSize = bS;
            return this;
        }

        @Override
        public TokenBucket.Builder withAction(TokenBucket.Action a) {
            this.action = a;
            return this;
        }

        @Override
        public TokenBucket.Builder withDscp(short d) {
            this.dscp = d;
            return this;
        }

        @Override
        public TokenBucket.Builder withType(TokenBucket.Type t) {
            this.type = t;
            return this;
        }

        @Override
        public DefaultTokenBucket build() {
            Preconditions.checkNotNull((Object)((Object)this.action), (Object)"Must specify an action");
            Preconditions.checkNotNull((Object)((Object)this.type), (Object)"Must specify a type");
            if (this.action == TokenBucket.Action.DSCP_CLASS || this.action == TokenBucket.Action.DSCP_PRECEDENCE) {
                Preconditions.checkArgument((this.dscp >= 0 && this.dscp <= 255 ? 1 : 0) != 0, (Object)"Dscp is out of range");
            }
            return new DefaultTokenBucket(this.rate, this.burstSize, this.action, this.dscp, this.type);
        }
    }
}

