/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.net.flow;

import com.google.common.annotations.Beta;
import java.util.Set;
import org.onlab.packet.Ip4Address;
import org.onlab.packet.Ip6Address;
import org.onlab.packet.IpPrefix;
import org.onlab.packet.MacAddress;
import org.onlab.packet.MplsLabel;
import org.onlab.packet.TpPort;
import org.onlab.packet.VlanId;
import org.onosproject.net.DeviceId;
import org.onosproject.net.PortNumber;
import org.onosproject.net.flow.criteria.Criterion;
import org.onosproject.net.flow.criteria.ExtensionSelector;
import org.onosproject.net.flow.criteria.PiCriterion;

public interface TrafficSelector {
    public Set<Criterion> criteria();

    public Criterion getCriterion(Criterion.Type var1);

    public static interface Builder {
        public Builder add(Criterion var1);

        public Builder matchInPort(PortNumber var1);

        public Builder matchInPhyPort(PortNumber var1);

        public Builder matchMetadata(long var1);

        public Builder matchEthDst(MacAddress var1);

        public Builder matchEthDstMasked(MacAddress var1, MacAddress var2);

        public Builder matchEthSrc(MacAddress var1);

        public Builder matchEthSrcMasked(MacAddress var1, MacAddress var2);

        public Builder matchEthType(short var1);

        public Builder matchVlanId(VlanId var1);

        public Builder matchVlanPcp(byte var1);

        public Builder matchInnerVlanId(VlanId var1);

        public Builder matchInnerVlanPcp(byte var1);

        public Builder matchIPDscp(byte var1);

        public Builder matchIPEcn(byte var1);

        public Builder matchIPProtocol(byte var1);

        public Builder matchIPSrc(IpPrefix var1);

        public Builder matchIPDst(IpPrefix var1);

        public Builder matchTcpSrc(TpPort var1);

        public Builder matchTcpSrcMasked(TpPort var1, TpPort var2);

        public Builder matchTcpDst(TpPort var1);

        public Builder matchTcpDstMasked(TpPort var1, TpPort var2);

        public Builder matchUdpSrc(TpPort var1);

        public Builder matchUdpSrcMasked(TpPort var1, TpPort var2);

        public Builder matchUdpDst(TpPort var1);

        public Builder matchUdpDstMasked(TpPort var1, TpPort var2);

        public Builder matchSctpSrc(TpPort var1);

        public Builder matchSctpSrcMasked(TpPort var1, TpPort var2);

        public Builder matchSctpDst(TpPort var1);

        public Builder matchSctpDstMasked(TpPort var1, TpPort var2);

        public Builder matchIcmpType(byte var1);

        public Builder matchIcmpCode(byte var1);

        public Builder matchIPv6Src(IpPrefix var1);

        public Builder matchIPv6Dst(IpPrefix var1);

        public Builder matchIPv6FlowLabel(int var1);

        public Builder matchIcmpv6Type(byte var1);

        public Builder matchIcmpv6Code(byte var1);

        public Builder matchIPv6NDTargetAddress(Ip6Address var1);

        public Builder matchIPv6NDSourceLinkLayerAddress(MacAddress var1);

        public Builder matchIPv6NDTargetLinkLayerAddress(MacAddress var1);

        public Builder matchMplsLabel(MplsLabel var1);

        public Builder matchMplsBos(boolean var1);

        public Builder matchTunnelId(long var1);

        public Builder matchIPv6ExthdrFlags(short var1);

        public Builder matchArpTpa(Ip4Address var1);

        public Builder matchArpSpa(Ip4Address var1);

        public Builder matchArpTha(MacAddress var1);

        public Builder matchArpSha(MacAddress var1);

        public Builder matchArpOp(int var1);

        @Beta
        public Builder matchPi(PiCriterion var1);

        public Builder extension(ExtensionSelector var1, DeviceId var2);

        public TrafficSelector build();
    }
}

