/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.net.flowobjective;

import com.google.common.annotations.Beta;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.onosproject.core.ApplicationId;
import org.onosproject.net.flow.TrafficSelector;
import org.onosproject.net.flow.TrafficTreatment;
import org.onosproject.net.flowobjective.NextObjective;
import org.onosproject.net.flowobjective.Objective;
import org.onosproject.net.flowobjective.ObjectiveContext;

@Beta
public final class DefaultNextObjective
implements NextObjective {
    private final List<TrafficTreatment> treatments;
    private final ApplicationId appId;
    private final NextObjective.Type type;
    private final Integer id;
    private final Objective.Operation op;
    private final Optional<ObjectiveContext> context;
    private final TrafficSelector meta;

    private DefaultNextObjective(Builder builder) {
        this.treatments = builder.treatments;
        this.appId = builder.appId;
        this.type = builder.type;
        this.id = builder.id;
        this.op = builder.op;
        this.context = Optional.ofNullable(builder.context);
        this.meta = builder.meta;
    }

    @Override
    public Collection<TrafficTreatment> next() {
        return this.treatments;
    }

    @Override
    public NextObjective.Type type() {
        return this.type;
    }

    @Override
    public int id() {
        return this.id;
    }

    @Override
    public int priority() {
        return 0;
    }

    @Override
    public ApplicationId appId() {
        return this.appId;
    }

    @Override
    public int timeout() {
        return 0;
    }

    @Override
    public boolean permanent() {
        return false;
    }

    @Override
    public Objective.Operation op() {
        return this.op;
    }

    @Override
    public Optional<ObjectiveContext> context() {
        return this.context;
    }

    @Override
    public TrafficSelector meta() {
        return this.meta;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.treatments, this.appId, this.type, this.id, this.op, this.meta});
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof DefaultNextObjective) {
            DefaultNextObjective other = (DefaultNextObjective)obj;
            return Objects.equals(this.treatments, other.treatments) && Objects.equals(this.appId, other.appId) && Objects.equals((Object)this.type, (Object)other.type) && Objects.equals(this.id, other.id) && Objects.equals((Object)this.op, (Object)other.op) && Objects.equals(this.meta, other.meta);
        }
        return false;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("id", this.id()).add("type", (Object)this.type()).add("op", (Object)this.op()).add("priority", this.priority()).add("next", this.next()).add("meta", (Object)this.meta()).add("appId", (Object)this.appId()).add("permanent", this.permanent()).add("timeout", this.timeout()).toString();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Override
    public Builder copy() {
        return new Builder(this);
    }

    public static final class Builder
    implements NextObjective.Builder {
        private ApplicationId appId;
        private NextObjective.Type type;
        private Integer id;
        private List<TrafficTreatment> treatments;
        private Objective.Operation op;
        private ObjectiveContext context;
        private TrafficSelector meta;
        private final ImmutableList.Builder<TrafficTreatment> listBuilder = ImmutableList.builder();

        private Builder() {
        }

        private Builder(NextObjective objective) {
            this.type = objective.type();
            this.id = objective.id();
            this.treatments = ImmutableList.copyOf(objective.next());
            this.listBuilder.addAll(objective.next());
            this.meta = objective.meta();
            this.appId = objective.appId();
            this.op = objective.op();
        }

        @Override
        public Builder withId(int nextId) {
            this.id = nextId;
            return this;
        }

        @Override
        public Builder withType(NextObjective.Type type) {
            this.type = type;
            return this;
        }

        @Override
        public Builder addTreatment(TrafficTreatment treatment) {
            this.listBuilder.add((Object)treatment);
            return this;
        }

        @Override
        public Builder makeTemporary(int timeout) {
            return this;
        }

        @Override
        public Builder makePermanent() {
            return this;
        }

        @Override
        public Builder fromApp(ApplicationId appId) {
            this.appId = appId;
            return this;
        }

        @Override
        public Builder withPriority(int priority) {
            return this;
        }

        @Override
        public Builder withMeta(TrafficSelector meta) {
            this.meta = meta;
            return this;
        }

        @Override
        public NextObjective add() {
            return this.add(null);
        }

        @Override
        public NextObjective remove() {
            return this.remove(null);
        }

        @Override
        public NextObjective add(ObjectiveContext context) {
            this.treatments = this.listBuilder.build();
            this.op = Objective.Operation.ADD;
            this.context = context;
            Preconditions.checkNotNull((Object)this.appId, (Object)"Must supply an application id");
            Preconditions.checkNotNull((Object)this.id, (Object)"id cannot be null");
            Preconditions.checkNotNull((Object)((Object)this.type), (Object)"The type cannot be null");
            Preconditions.checkArgument((!this.treatments.isEmpty() ? 1 : 0) != 0, (Object)"Must have at least one treatment");
            return new DefaultNextObjective(this);
        }

        @Override
        public NextObjective remove(ObjectiveContext context) {
            this.treatments = this.listBuilder.build();
            this.op = Objective.Operation.REMOVE;
            this.context = context;
            Preconditions.checkNotNull((Object)this.appId, (Object)"Must supply an application id");
            Preconditions.checkNotNull((Object)this.id, (Object)"id cannot be null");
            Preconditions.checkNotNull((Object)((Object)this.type), (Object)"The type cannot be null");
            return new DefaultNextObjective(this);
        }

        @Override
        public NextObjective addToExisting() {
            return this.addToExisting(null);
        }

        @Override
        public NextObjective removeFromExisting() {
            return this.removeFromExisting(null);
        }

        @Override
        public NextObjective addToExisting(ObjectiveContext context) {
            this.treatments = this.listBuilder.build();
            this.op = Objective.Operation.ADD_TO_EXISTING;
            this.context = context;
            Preconditions.checkNotNull((Object)this.appId, (Object)"Must supply an application id");
            Preconditions.checkNotNull((Object)this.id, (Object)"id cannot be null");
            Preconditions.checkNotNull((Object)((Object)this.type), (Object)"The type cannot be null");
            Preconditions.checkArgument((!this.treatments.isEmpty() ? 1 : 0) != 0, (Object)"Must have at least one treatment");
            return new DefaultNextObjective(this);
        }

        @Override
        public NextObjective removeFromExisting(ObjectiveContext context) {
            this.treatments = this.listBuilder.build();
            this.op = Objective.Operation.REMOVE_FROM_EXISTING;
            this.context = context;
            Preconditions.checkNotNull((Object)this.appId, (Object)"Must supply an application id");
            Preconditions.checkNotNull((Object)this.id, (Object)"id cannot be null");
            Preconditions.checkNotNull((Object)((Object)this.type), (Object)"The type cannot be null");
            return new DefaultNextObjective(this);
        }

        @Override
        public NextObjective modify() {
            return this.modify(null);
        }

        @Override
        public NextObjective modify(ObjectiveContext context) {
            this.treatments = this.listBuilder.build();
            this.op = Objective.Operation.MODIFY;
            this.context = context;
            Preconditions.checkNotNull((Object)this.appId, (Object)"Must supply an application id");
            Preconditions.checkNotNull((Object)this.id, (Object)"id cannot be null");
            Preconditions.checkNotNull((Object)((Object)this.type), (Object)"The type cannot be null");
            Preconditions.checkArgument((!this.treatments.isEmpty() ? 1 : 0) != 0, (Object)"Must have at least one treatment");
            return new DefaultNextObjective(this);
        }

        @Override
        public NextObjective verify() {
            return this.verify(null);
        }

        @Override
        public NextObjective verify(ObjectiveContext context) {
            this.treatments = this.listBuilder.build();
            this.op = Objective.Operation.VERIFY;
            this.context = context;
            Preconditions.checkNotNull((Object)this.appId, (Object)"Must supply an application id");
            Preconditions.checkNotNull((Object)this.id, (Object)"id cannot be null");
            Preconditions.checkNotNull((Object)((Object)this.type), (Object)"The type cannot be null");
            return new DefaultNextObjective(this);
        }
    }
}

