/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.net.meter;

import java.util.Optional;
import org.onosproject.net.meter.MeterFailReason;

public final class MeterStoreResult {
    private final Type type;
    private final Optional<MeterFailReason> reason;

    private MeterStoreResult(Type type, MeterFailReason reason) {
        this.type = type;
        this.reason = Optional.ofNullable(reason);
    }

    public Type type() {
        return this.type;
    }

    public Optional<MeterFailReason> reason() {
        return this.reason;
    }

    public static MeterStoreResult success() {
        return new MeterStoreResult(Type.SUCCESS, null);
    }

    public static MeterStoreResult fail(MeterFailReason reason) {
        return new MeterStoreResult(Type.FAIL, reason);
    }

    public static enum Type {
        SUCCESS,
        FAIL;

    }
}

