/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.net.pi.runtime;

import com.google.common.annotations.Beta;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import org.onlab.util.ImmutableByteSequence;
import org.onosproject.net.pi.model.PiControlMetadataId;

@Beta
public final class PiControlMetadata {
    private final PiControlMetadataId id;
    private final ImmutableByteSequence value;

    private PiControlMetadata(PiControlMetadataId id, ImmutableByteSequence value) {
        this.id = id;
        this.value = value;
    }

    public PiControlMetadataId id() {
        return this.id;
    }

    public ImmutableByteSequence value() {
        return this.value;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PiControlMetadata piPacket = (PiControlMetadata)o;
        return Objects.equal((Object)((Object)this.id), (Object)((Object)piPacket.id())) && Objects.equal((Object)this.value, (Object)piPacket.value());
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.id, this.value});
    }

    public String toString() {
        return this.id().toString() + " = " + this.value.toString();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private PiControlMetadataId id;
        private ImmutableByteSequence value;

        private Builder() {
        }

        public Builder withId(PiControlMetadataId id) {
            this.id = id;
            return this;
        }

        public Builder withValue(ImmutableByteSequence value) {
            this.value = value;
            return this;
        }

        public PiControlMetadata build() {
            Preconditions.checkNotNull((Object)((Object)this.id));
            Preconditions.checkNotNull((Object)this.value);
            return new PiControlMetadata(this.id, this.value);
        }
    }
}

