/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.net.topology;

import org.onlab.graph.ScalarWeight;
import org.onlab.graph.Weight;
import org.onosproject.net.Link;
import org.onosproject.net.topology.LinkWeigher;
import org.onosproject.net.topology.TopologyEdge;

public class HopCountLinkWeigher
implements LinkWeigher {
    public static final LinkWeigher DEFAULT_HOP_COUNT_WEIGHER = new HopCountLinkWeigher();
    private static final ScalarWeight ZERO = new ScalarWeight(0.0);
    private static final ScalarWeight ONE = new ScalarWeight(1.0);
    private static final ScalarWeight DEFAULT_INDIRECT = new ScalarWeight(32767.0);
    private final ScalarWeight indirectLinkCost;

    public HopCountLinkWeigher() {
        this.indirectLinkCost = DEFAULT_INDIRECT;
    }

    public HopCountLinkWeigher(double indirectLinkCost) {
        this.indirectLinkCost = new ScalarWeight(indirectLinkCost);
    }

    public Weight weight(TopologyEdge edge) {
        if (edge.link().state() == Link.State.ACTIVE) {
            return edge.link().type() == Link.Type.INDIRECT ? this.indirectLinkCost : ONE;
        }
        return this.getNonViableWeight();
    }

    public Weight getInitialWeight() {
        return ZERO;
    }

    public Weight getNonViableWeight() {
        return ScalarWeight.NON_VIABLE_WEIGHT;
    }
}

