/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.store.primitives;

import com.google.common.base.Throwables;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.onosproject.store.service.AsyncDocumentTree;
import org.onosproject.store.service.ConsistentMapException;
import org.onosproject.store.service.DocumentException;
import org.onosproject.store.service.DocumentPath;
import org.onosproject.store.service.DocumentTree;
import org.onosproject.store.service.DocumentTreeListener;
import org.onosproject.store.service.Synchronous;
import org.onosproject.store.service.Versioned;

public class DefaultDocumentTree<V>
extends Synchronous<AsyncDocumentTree<V>>
implements DocumentTree<V> {
    private final AsyncDocumentTree<V> backingTree;
    private final long operationTimeoutMillis;

    public DefaultDocumentTree(AsyncDocumentTree<V> backingTree, long operationTimeoutMillis) {
        super(backingTree);
        this.backingTree = backingTree;
        this.operationTimeoutMillis = operationTimeoutMillis;
    }

    @Override
    public DocumentPath root() {
        return this.backingTree.root();
    }

    @Override
    public Map<String, Versioned<V>> getChildren(DocumentPath path) {
        return this.complete(this.backingTree.getChildren(path));
    }

    @Override
    public Versioned<V> get(DocumentPath path) {
        return this.complete(this.backingTree.get(path));
    }

    @Override
    public Versioned<V> set(DocumentPath path, V value) {
        return this.complete(this.backingTree.set(path, value));
    }

    @Override
    public boolean create(DocumentPath path, V value) {
        return this.complete(this.backingTree.create(path, value));
    }

    @Override
    public boolean createRecursive(DocumentPath path, V value) {
        return this.complete(this.backingTree.createRecursive(path, value));
    }

    @Override
    public boolean replace(DocumentPath path, V newValue, long version) {
        return this.complete(this.backingTree.replace(path, (long)newValue, version));
    }

    @Override
    public boolean replace(DocumentPath path, V newValue, V currentValue) {
        return this.complete(this.backingTree.replace(path, newValue, currentValue));
    }

    @Override
    public Versioned<V> removeNode(DocumentPath path) {
        return this.complete(this.backingTree.removeNode(path));
    }

    @Override
    public void addListener(DocumentPath path, DocumentTreeListener<V> listener) {
        this.complete(this.backingTree.addListener(path, listener));
    }

    @Override
    public void removeListener(DocumentTreeListener<V> listener) {
        this.complete(this.backingTree.removeListener(listener));
    }

    @Override
    public void addListener(DocumentTreeListener<V> listener) {
        this.complete(this.backingTree.addListener(listener));
    }

    private <T> T complete(CompletableFuture<T> future) {
        try {
            return future.get(this.operationTimeoutMillis, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new DocumentException.Interrupted();
        }
        catch (TimeoutException e) {
            throw new DocumentException.Timeout(this.name());
        }
        catch (ExecutionException e) {
            Throwables.throwIfUnchecked((Throwable)e.getCause());
            throw new ConsistentMapException(e.getCause());
        }
    }
}

