/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.ui.model.topo;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import org.onosproject.net.Device;
import org.onosproject.net.DeviceId;
import org.onosproject.net.region.RegionId;
import org.onosproject.ui.model.topo.UiNode;
import org.onosproject.ui.model.topo.UiRegion;
import org.onosproject.ui.model.topo.UiTopology;

public class UiDevice
extends UiNode {
    private static final String DEVICE_CANNOT_BE_NULL = "Device cannot be null";
    private final UiTopology topology;
    private final DeviceId deviceId;
    private RegionId regionId;

    public UiDevice(UiTopology topology, Device device) {
        Preconditions.checkNotNull((Object)device, (Object)DEVICE_CANNOT_BE_NULL);
        this.topology = topology;
        this.deviceId = device.id();
    }

    public void setRegionId(RegionId regionId) {
        this.regionId = regionId;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("id", (Object)this.id()).add("region", (Object)this.regionId).toString();
    }

    public DeviceId id() {
        return this.deviceId;
    }

    @Override
    public String idAsString() {
        return this.id().toString();
    }

    public Device backingDevice() {
        return this.topology.services.device().getDevice(this.deviceId);
    }

    public RegionId regionId() {
        return this.regionId;
    }

    public UiRegion uiRegion() {
        return this.topology.findRegion(this.regionId);
    }

    public String type() {
        Device device = this.backingDevice();
        return device == null ? null : device.type().toString().toLowerCase();
    }
}

