/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.ui.model.topo;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import org.onosproject.net.region.Region;
import org.onosproject.net.region.RegionId;
import org.onosproject.ui.model.topo.UiRegion;
import org.onosproject.ui.model.topo.UiTopoLayoutId;

public class UiTopoLayout {
    static final double SCALE_MIN = 0.01;
    static final double SCALE_MAX = 100.0;
    static final double SCALE_DEFAULT = 1.0;
    static final double OFFSET_DEFAULT = 0.0;
    static final String E_ROOT_PARENT = "Cannot change parent ID of root layout";
    static final String E_ROOT_REGION = "Cannot set region on root layout";
    static final String E_SPRITES_SET = "Cannot set geomap if sprites is set";
    static final String E_GEOMAP_SET = "Cannot set sprites if geomap is set";
    static final String E_SCALE_OOB = "Scale out of bounds; expected [0.01..100.0]";
    private final UiTopoLayoutId id;
    private Region region;
    private UiTopoLayoutId parent;
    private String geomap;
    private String sprites;
    private double scale = 1.0;
    private double offsetX = 0.0;
    private double offsetY = 0.0;

    public UiTopoLayout(UiTopoLayoutId id) {
        Preconditions.checkNotNull((Object)((Object)id), (Object)"layout ID cannot be null");
        this.id = id;
        if (this.isRoot()) {
            this.parent = id;
        }
    }

    public boolean isRoot() {
        return UiTopoLayoutId.DEFAULT_ID.equals((Object)this.id);
    }

    public UiTopoLayoutId id() {
        return this.id;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("id", (Object)this.id).add("region", (Object)this.region).add("parent", (Object)this.parent).add("geomap", (Object)this.geomap).add("sprites", (Object)this.sprites).add("scale", this.scale).add("offsetX", this.offsetX).add("offsetY", this.offsetY).toString();
    }

    public UiTopoLayout region(Region region) {
        if (this.isRoot()) {
            throw new IllegalArgumentException(E_ROOT_REGION);
        }
        this.region = region;
        return this;
    }

    public Region region() {
        return this.region;
    }

    public RegionId regionId() {
        return this.isRoot() ? UiRegion.NULL_ID : (this.region == null ? null : this.region.id());
    }

    public UiTopoLayout parent(UiTopoLayoutId parentId) {
        if (this.isRoot()) {
            throw new IllegalArgumentException(E_ROOT_PARENT);
        }
        this.parent = parentId;
        return this;
    }

    public UiTopoLayoutId parent() {
        return this.parent;
    }

    public UiTopoLayout geomap(String geomap) {
        if (this.sprites != null) {
            throw new IllegalArgumentException(E_SPRITES_SET);
        }
        this.geomap = geomap;
        return this;
    }

    public String geomap() {
        return this.geomap;
    }

    public UiTopoLayout sprites(String sprites) {
        if (this.geomap != null) {
            throw new IllegalArgumentException(E_GEOMAP_SET);
        }
        this.sprites = sprites;
        return this;
    }

    public String sprites() {
        return this.sprites;
    }

    private boolean scaleWithinBounds(double scale) {
        return scale >= 0.01 && scale <= 100.0;
    }

    public UiTopoLayout scale(double scale) {
        Preconditions.checkArgument((boolean)this.scaleWithinBounds(scale), (Object)E_SCALE_OOB);
        this.scale = scale;
        return this;
    }

    public double scale() {
        return this.scale;
    }

    public UiTopoLayout offsetX(double offsetX) {
        this.offsetX = offsetX;
        return this;
    }

    public double offsetX() {
        return this.offsetX;
    }

    public UiTopoLayout offsetY(double offsetY) {
        this.offsetY = offsetY;
        return this;
    }

    public double offsetY() {
        return this.offsetY;
    }
}

