/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.ui.topo;

import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.onosproject.ui.topo.DeviceHighlight;
import org.onosproject.ui.topo.Highlights;
import org.onosproject.ui.topo.HostHighlight;

public class HighlightsTest {
    private static final String DEV_1 = "dev-1";
    private static final String DEV_2 = "dev-2";
    private static final String HOST_A = "Host...A";
    private Highlights highlights;
    private DeviceHighlight dh1;
    private DeviceHighlight dh2;
    private HostHighlight hha;

    @Before
    public void setUp() {
        this.highlights = new Highlights();
    }

    @Test
    public void basic() {
        Assert.assertEquals((String)"devices", (long)0L, (long)this.highlights.devices().size());
        Assert.assertEquals((String)"hosts", (long)0L, (long)this.highlights.hosts().size());
        Assert.assertEquals((String)"links", (long)0L, (long)this.highlights.links().size());
        Assert.assertEquals((String)"sudue", (Object)Highlights.Amount.ZERO, (Object)this.highlights.subdueLevel());
    }

    @Test
    public void coupleOfDevices() {
        this.dh1 = new DeviceHighlight(DEV_1);
        this.dh2 = new DeviceHighlight(DEV_2);
        this.highlights.add(this.dh1);
        this.highlights.add(this.dh2);
        Assert.assertTrue((String)"missing dh1", (boolean)this.highlights.devices().contains(this.dh1));
        Assert.assertTrue((String)"missing dh2", (boolean)this.highlights.devices().contains(this.dh2));
    }

    @Test
    public void alternateSubdue() {
        this.highlights.subdueAllElse(Highlights.Amount.MINIMALLY);
        Assert.assertEquals((String)"wrong level", (Object)Highlights.Amount.MINIMALLY, (Object)this.highlights.subdueLevel());
    }

    @Test
    public void highlightRetrieval() {
        this.dh1 = new DeviceHighlight(DEV_1);
        this.hha = new HostHighlight(HOST_A);
        this.highlights.add(this.dh1).add(this.hha);
        Assert.assertNull((String)"dev as host", (Object)this.highlights.getHost(DEV_1));
        Assert.assertNull((String)"host as dev", (Object)this.highlights.getDevice(HOST_A));
        Assert.assertEquals((String)"missed dev as dev", (Object)this.dh1, (Object)this.highlights.getDevice(DEV_1));
        Assert.assertEquals((String)"missed dev as node", (Object)this.dh1, (Object)this.highlights.getNode(DEV_1));
        Assert.assertEquals((String)"missed host as host", (Object)this.hha, (Object)this.highlights.getHost(HOST_A));
        Assert.assertEquals((String)"missed host as node", (Object)this.hha, (Object)this.highlights.getNode(HOST_A));
    }
}

