/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.net.host;

import com.google.common.base.MoreObjects;
import com.google.common.base.Objects;
import com.google.common.collect.ImmutableSet;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Set;
import org.onlab.packet.EthType;
import org.onlab.packet.IpAddress;
import org.onlab.packet.MacAddress;
import org.onlab.packet.VlanId;
import org.onosproject.net.AbstractDescription;
import org.onosproject.net.HostLocation;
import org.onosproject.net.SparseAnnotations;
import org.onosproject.net.host.HostDescription;

public class DefaultHostDescription
extends AbstractDescription
implements HostDescription {
    private final MacAddress mac;
    private final VlanId vlan;
    private final Set<HostLocation> locations;
    private final Set<IpAddress> ip;
    private final VlanId innerVlan;
    private final EthType tpid;
    private final boolean configured;

    public DefaultHostDescription(MacAddress mac, VlanId vlan, HostLocation location, SparseAnnotations ... annotations) {
        this(mac, vlan, location, Collections.emptySet(), annotations);
    }

    public DefaultHostDescription(MacAddress mac, VlanId vlan, HostLocation location, IpAddress ip, SparseAnnotations ... annotations) {
        this(mac, vlan, location, (Set<IpAddress>)ImmutableSet.of((Object)ip), annotations);
    }

    public DefaultHostDescription(MacAddress mac, VlanId vlan, HostLocation location, Set<IpAddress> ip, SparseAnnotations ... annotations) {
        this(mac, vlan, location, ip, false, annotations);
    }

    public DefaultHostDescription(MacAddress mac, VlanId vlan, HostLocation location, boolean configured, SparseAnnotations ... annotations) {
        this(mac, vlan, location, Collections.emptySet(), configured, annotations);
    }

    public DefaultHostDescription(MacAddress mac, VlanId vlan, HostLocation location, Set<IpAddress> ip, boolean configured, SparseAnnotations ... annotations) {
        this(mac, vlan, Collections.singleton(location), ip, configured, annotations);
    }

    public DefaultHostDescription(MacAddress mac, VlanId vlan, Set<HostLocation> locations, Set<IpAddress> ip, boolean configured, SparseAnnotations ... annotations) {
        this(mac, vlan, locations, ip, VlanId.NONE, EthType.EtherType.UNKNOWN.ethType(), configured, annotations);
    }

    public DefaultHostDescription(MacAddress mac, VlanId vlan, Set<HostLocation> locations, Set<IpAddress> ip, VlanId innerVlan, EthType tpid, boolean configured, SparseAnnotations ... annotations) {
        super(annotations);
        this.mac = mac;
        this.vlan = vlan;
        this.locations = new HashSet<HostLocation>(locations);
        this.ip = new HashSet<IpAddress>(ip);
        this.innerVlan = innerVlan;
        this.tpid = tpid;
        this.configured = configured;
    }

    @Override
    public MacAddress hwAddress() {
        return this.mac;
    }

    @Override
    public VlanId vlan() {
        return this.vlan;
    }

    @Override
    public HostLocation location() {
        return this.locations.stream().sorted(Comparator.comparingLong(HostLocation::time).reversed()).findFirst().orElse(null);
    }

    @Override
    public Set<HostLocation> locations() {
        return this.locations;
    }

    @Override
    public Set<IpAddress> ipAddress() {
        return this.ip;
    }

    @Override
    public boolean configured() {
        return this.configured;
    }

    @Override
    public VlanId innerVlan() {
        return this.innerVlan;
    }

    @Override
    public EthType tpid() {
        return this.tpid;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("mac", (Object)this.mac).add("vlan", (Object)this.vlan).add("locations", this.locations).add("ipAddress", this.ip).add("configured", this.configured).add("innerVlanId", (Object)this.innerVlan).add("outerTPID", (Object)this.tpid).toString();
    }

    @Override
    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{super.hashCode(), this.mac, this.vlan, this.locations, this.ip});
    }

    @Override
    public boolean equals(Object object) {
        if (object != null && this.getClass() == object.getClass()) {
            if (!super.equals(object)) {
                return false;
            }
            DefaultHostDescription that = (DefaultHostDescription)object;
            return Objects.equal((Object)this.mac, (Object)that.mac) && Objects.equal((Object)this.vlan, (Object)that.vlan) && Objects.equal(this.locations, that.locations) && Objects.equal(this.ip, that.ip) && Objects.equal((Object)this.innerVlan, (Object)that.innerVlan) && Objects.equal((Object)this.tpid, (Object)that.tpid);
        }
        return false;
    }
}

