/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.net.pi.runtime;

import com.google.common.base.MoreObjects;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import org.onosproject.net.DeviceId;
import org.onosproject.net.pi.model.PiActionProfileId;
import org.onosproject.net.pi.runtime.PiActionGroupMember;
import org.onosproject.net.pi.runtime.PiActionGroupMemberId;
import org.onosproject.net.pi.runtime.PiEntityType;
import org.onosproject.net.pi.runtime.PiHandle;

public final class PiActionGroupMemberHandle
extends PiHandle<PiActionGroupMember> {
    private final PiActionGroupMemberId memberId;
    private final PiActionProfileId actionProfileId;

    private PiActionGroupMemberHandle(DeviceId deviceId, PiActionProfileId actionProfileId, PiActionGroupMemberId memberId) {
        super(deviceId);
        this.actionProfileId = actionProfileId;
        this.memberId = memberId;
    }

    public static PiActionGroupMemberHandle of(DeviceId deviceId, PiActionProfileId actionProfileId, PiActionGroupMemberId memberId) {
        return new PiActionGroupMemberHandle(deviceId, actionProfileId, memberId);
    }

    public static PiActionGroupMemberHandle of(DeviceId deviceId, PiActionGroupMember member) {
        Preconditions.checkNotNull((Object)member);
        return new PiActionGroupMemberHandle(deviceId, member.actionProfile(), member.id());
    }

    public PiActionGroupMemberId memberId() {
        return this.memberId;
    }

    public PiActionProfileId actionProfileId() {
        return this.actionProfileId;
    }

    @Override
    public PiEntityType entityType() {
        return PiEntityType.GROUP_MEMBER;
    }

    @Override
    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.deviceId(), this.actionProfileId, this.memberId});
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        PiActionGroupMemberHandle other = (PiActionGroupMemberHandle)obj;
        return Objects.equal((Object)this.deviceId(), (Object)other.deviceId()) && Objects.equal((Object)((Object)this.actionProfileId), (Object)((Object)other.actionProfileId)) && Objects.equal((Object)this.memberId, (Object)other.memberId);
    }

    @Override
    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("deviceId", (Object)this.deviceId()).add("actionProfileId", (Object)this.actionProfileId).add("memberId", (Object)this.memberId).toString();
    }
}

