/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.net.pi.runtime;

import com.google.common.annotations.Beta;
import com.google.common.base.MoreObjects;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import java.util.Optional;
import org.onosproject.net.pi.model.PiTableId;
import org.onosproject.net.pi.runtime.PiActionGroupId;
import org.onosproject.net.pi.runtime.PiActionGroupMemberId;
import org.onosproject.net.pi.runtime.PiEntity;
import org.onosproject.net.pi.runtime.PiEntityType;
import org.onosproject.net.pi.runtime.PiMatchKey;
import org.onosproject.net.pi.runtime.PiTableAction;

@Beta
public final class PiTableEntry
implements PiEntity {
    private static final int NO_PRIORITY = -1;
    private static final double NO_TIMEOUT = -1.0;
    private final PiTableId tableId;
    private final PiMatchKey matchKey;
    private final PiTableAction tableAction;
    private final boolean isDefaultAction;
    private final long cookie;
    private final int priority;
    private final double timeout;

    private PiTableEntry(PiTableId tableId, PiMatchKey matchKey, PiTableAction tableAction, boolean isDefaultAction, long cookie, int priority, double timeout) {
        this.tableId = tableId;
        this.matchKey = matchKey;
        this.tableAction = tableAction;
        this.isDefaultAction = isDefaultAction;
        this.cookie = cookie;
        this.priority = priority;
        this.timeout = timeout;
    }

    public PiTableId table() {
        return this.tableId;
    }

    public PiMatchKey matchKey() {
        return this.matchKey;
    }

    public PiTableAction action() {
        return this.tableAction;
    }

    public boolean isDefaultAction() {
        return this.isDefaultAction;
    }

    public long cookie() {
        return this.cookie;
    }

    public Optional<Integer> priority() {
        return this.priority == -1 ? Optional.empty() : Optional.of(this.priority);
    }

    public Optional<Double> timeout() {
        return this.timeout == -1.0 ? Optional.empty() : Optional.of(this.timeout);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PiTableEntry that = (PiTableEntry)o;
        return this.priority == that.priority && this.cookie == that.cookie && Double.compare(that.timeout, this.timeout) == 0 && Objects.equal((Object)this.tableId, (Object)that.tableId) && Objects.equal((Object)this.matchKey, (Object)that.matchKey) && Objects.equal((Object)this.isDefaultAction, (Object)that.isDefaultAction) && Objects.equal((Object)this.tableAction, (Object)that.tableAction);
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.tableId, this.matchKey, this.isDefaultAction, this.tableAction, this.priority, this.cookie, this.timeout});
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("tableId", (Object)this.tableId).add("matchKey", this.isDefaultAction ? "DEFAULT-ACTION" : this.matchKey).add("tableAction", (Object)this.tableActionToString(this.tableAction)).add("priority", (Object)(this.priority == -1 ? "N/A" : String.valueOf(this.priority))).add("timeout", (Object)(this.timeout == -1.0 ? "PERMANENT" : String.valueOf(this.timeout))).toString();
    }

    private String tableActionToString(PiTableAction tableAction) {
        if (tableAction == null) {
            return "null";
        }
        switch (tableAction.type()) {
            case ACTION_GROUP_ID: {
                return "GROUP:" + ((PiActionGroupId)tableAction).id();
            }
            case GROUP_MEMBER_ID: {
                return "GROUP_MEMBER:" + ((PiActionGroupMemberId)tableAction).id();
            }
        }
        return tableAction.toString();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Override
    public PiEntityType piEntityType() {
        return PiEntityType.TABLE_ENTRY;
    }

    public static final class Builder {
        private PiTableId tableId;
        private PiMatchKey matchKey = PiMatchKey.EMPTY;
        private PiTableAction tableAction;
        private long cookie = 0L;
        private int priority = -1;
        private double timeout = -1.0;

        private Builder() {
        }

        public Builder forTable(PiTableId tableId) {
            this.tableId = (PiTableId)Preconditions.checkNotNull((Object)tableId, (Object)"Table ID cannot be null");
            return this;
        }

        public Builder withAction(PiTableAction tableAction) {
            this.tableAction = (PiTableAction)Preconditions.checkNotNull((Object)tableAction, (Object)"Action cannot be null");
            return this;
        }

        public Builder withMatchKey(PiMatchKey matchKey) {
            this.matchKey = (PiMatchKey)Preconditions.checkNotNull((Object)matchKey, (Object)"Match key cannot be null");
            return this;
        }

        public Builder withCookie(long cookie) {
            this.cookie = cookie;
            return this;
        }

        public Builder withPriority(int priority) {
            Preconditions.checkArgument((priority >= 0 ? 1 : 0) != 0, (Object)"Priority must be a positive integer.");
            this.priority = priority;
            return this;
        }

        public Builder withTimeout(double seconds) {
            Preconditions.checkArgument((seconds > 0.0 ? 1 : 0) != 0, (Object)"Timeout must be greater than zero.");
            this.timeout = seconds;
            return this;
        }

        public PiTableEntry build() {
            Preconditions.checkNotNull((Object)this.tableId);
            Preconditions.checkNotNull((Object)this.matchKey);
            boolean isDefaultAction = this.matchKey.equals(PiMatchKey.EMPTY);
            return new PiTableEntry(this.tableId, this.matchKey, this.tableAction, isDefaultAction, this.cookie, this.priority, this.timeout);
        }
    }
}

