/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.net.flow.criteria;

import com.google.common.testing.EqualsTester;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Test;
import org.onlab.util.ImmutableByteSequence;
import org.onosproject.net.flow.criteria.Criterion;
import org.onosproject.net.flow.criteria.PiCriterion;
import org.onosproject.net.pi.model.PiMatchFieldId;
import org.onosproject.net.pi.runtime.PiExactFieldMatch;
import org.onosproject.net.pi.runtime.PiFieldMatch;
import org.onosproject.net.pi.runtime.PiLpmFieldMatch;
import org.onosproject.net.pi.runtime.PiRangeFieldMatch;
import org.onosproject.net.pi.runtime.PiTernaryFieldMatch;

public class PiCriteriaTest {
    private PiMatchFieldId ethMatchFieldId = PiMatchFieldId.of((String)"ethernet_t.etherType");
    private byte[] matchExactBytes1 = new byte[]{8, 0};
    private byte[] matchExactBytes2 = new byte[]{8, 6};
    private Criterion matchPiExactByte1 = PiCriterion.builder().matchExact(this.ethMatchFieldId, this.matchExactBytes1).build();
    private Criterion sameAsMatchPiExactByte1 = PiCriterion.builder().matchExact(this.ethMatchFieldId, this.matchExactBytes1).build();
    private Criterion matchPiExactByte2 = PiCriterion.builder().matchExact(this.ethMatchFieldId, this.matchExactBytes2).build();
    private short matchExactShort1 = (short)2048;
    private short matchExactShort2 = (short)2054;
    private Criterion matchPiExactShort1 = PiCriterion.builder().matchExact(this.ethMatchFieldId, this.matchExactShort1).build();
    private Criterion sameAsMatchPiExactShort1 = PiCriterion.builder().matchExact(this.ethMatchFieldId, this.matchExactShort1).build();
    private Criterion matchPiExactShort2 = PiCriterion.builder().matchExact(this.ethMatchFieldId, this.matchExactShort2).build();
    private int matchExactInt1 = 2048;
    private int matchExactInt2 = 2054;
    private Criterion matchPiExactInt1 = PiCriterion.builder().matchExact(this.ethMatchFieldId, this.matchExactInt1).build();
    private Criterion sameAsMatchPiExactInt1 = PiCriterion.builder().matchExact(this.ethMatchFieldId, this.matchExactInt1).build();
    private Criterion matchPiExactInt2 = PiCriterion.builder().matchExact(this.ethMatchFieldId, this.matchExactInt2).build();
    private long matchExactLong1 = 2048L;
    private long matchExactLong2 = 2054L;
    private Criterion matchPiExactLong1 = PiCriterion.builder().matchExact(this.ethMatchFieldId, this.matchExactLong1).build();
    private Criterion sameAsMatchPiExactLong1 = PiCriterion.builder().matchExact(this.ethMatchFieldId, this.matchExactLong1).build();
    private Criterion matchPiExactLong2 = PiCriterion.builder().matchExact(this.ethMatchFieldId, this.matchExactLong2).build();
    private PiMatchFieldId ipv4MatchFieldId = PiMatchFieldId.of((String)"ipv4_t.dstAddr");
    private int mask = 0xFFFFFF;
    private byte[] matchLpmBytes1 = new byte[]{10, 1, 1, 1};
    private byte[] matchLpmBytes2 = new byte[]{10, 1, 1, 2};
    private Criterion matchPiLpmByte1 = PiCriterion.builder().matchLpm(this.ipv4MatchFieldId, this.matchLpmBytes1, this.mask).build();
    private Criterion sameAsMatchPiLpmByte1 = PiCriterion.builder().matchLpm(this.ipv4MatchFieldId, this.matchLpmBytes1, this.mask).build();
    private Criterion matchPiLpmByte2 = PiCriterion.builder().matchLpm(this.ipv4MatchFieldId, this.matchLpmBytes2, this.mask).build();
    private short matchLpmShort1 = (short)2570;
    private short matchLpmShort2 = (short)2571;
    private Criterion matchPiLpmShort1 = PiCriterion.builder().matchLpm(this.ipv4MatchFieldId, this.matchLpmShort1, this.mask).build();
    private Criterion sameAsMatchPiLpmShort1 = PiCriterion.builder().matchLpm(this.ipv4MatchFieldId, this.matchLpmShort1, this.mask).build();
    private Criterion matchPiLpmShort2 = PiCriterion.builder().matchLpm(this.ipv4MatchFieldId, this.matchLpmShort2, this.mask).build();
    private int matchLpmInt1 = 0xA010101;
    private int matchLpmInt2 = 167837954;
    private Criterion matchPiLpmInt1 = PiCriterion.builder().matchLpm(this.ipv4MatchFieldId, this.matchLpmInt1, this.mask).build();
    private Criterion sameAsMatchPiLpmInt1 = PiCriterion.builder().matchLpm(this.ipv4MatchFieldId, this.matchLpmInt1, this.mask).build();
    private Criterion matchPiLpmInt2 = PiCriterion.builder().matchLpm(this.ipv4MatchFieldId, this.matchLpmInt2, this.mask).build();
    private long matchLpmLong1 = 0xA010101L;
    private long matchLpmLong2 = 167837954L;
    private Criterion matchPiLpmLong1 = PiCriterion.builder().matchLpm(this.ipv4MatchFieldId, this.matchLpmLong1, this.mask).build();
    private Criterion sameAsMatchPiLpmLong1 = PiCriterion.builder().matchLpm(this.ipv4MatchFieldId, this.matchLpmLong1, this.mask).build();
    private Criterion matchPiLpmLong2 = PiCriterion.builder().matchLpm(this.ipv4MatchFieldId, this.matchLpmLong2, this.mask).build();
    private byte[] matchTernaryBytes1 = new byte[]{10, 1, 1, 1};
    private byte[] matchTernaryBytes2 = new byte[]{10, 1, 1, 2};
    private byte[] matchTernaryMaskBytes = new byte[]{127, 127, 127, 0};
    private Criterion matchPiTernaryByte1 = PiCriterion.builder().matchTernary(this.ipv4MatchFieldId, this.matchTernaryBytes1, this.matchTernaryMaskBytes).build();
    private Criterion sameAsMatchPiTernaryByte1 = PiCriterion.builder().matchTernary(this.ipv4MatchFieldId, this.matchTernaryBytes1, this.matchTernaryMaskBytes).build();
    private Criterion matchPiTernaryByte2 = PiCriterion.builder().matchTernary(this.ipv4MatchFieldId, this.matchTernaryBytes2, this.matchTernaryMaskBytes).build();
    private short matchTernaryShort1 = (short)2570;
    private short matchTernaryShort2 = (short)2571;
    private short matchTernaryMaskShort = (short)4080;
    private Criterion matchPiTernaryShort1 = PiCriterion.builder().matchTernary(this.ipv4MatchFieldId, this.matchTernaryShort1, this.matchTernaryMaskShort).build();
    private Criterion sameAsMatchPiTernaryShort1 = PiCriterion.builder().matchTernary(this.ipv4MatchFieldId, this.matchTernaryShort1, this.matchTernaryMaskShort).build();
    private Criterion matchPiTernaryShort2 = PiCriterion.builder().matchTernary(this.ipv4MatchFieldId, this.matchTernaryShort2, this.matchTernaryMaskShort).build();
    private int matchTernaryInt1 = 0xA010101;
    private int matchTernaryInt2 = 167837954;
    private int matchTernaryMaskInt = 65535;
    private Criterion matchPiTernaryInt1 = PiCriterion.builder().matchTernary(this.ipv4MatchFieldId, this.matchTernaryInt1, this.matchTernaryMaskInt).build();
    private Criterion sameAsMatchPiTernaryInt1 = PiCriterion.builder().matchTernary(this.ipv4MatchFieldId, this.matchTernaryInt1, this.matchTernaryMaskInt).build();
    private Criterion matchPiTernaryInt2 = PiCriterion.builder().matchTernary(this.ipv4MatchFieldId, this.matchTernaryInt2, this.matchTernaryMaskInt).build();
    private long matchTernaryLong1 = 0xA010101L;
    private long matchTernaryLong2 = 167837954L;
    private long matchTernaryMaskLong = 65535L;
    private Criterion matchPiTernaryLong1 = PiCriterion.builder().matchTernary(this.ipv4MatchFieldId, this.matchTernaryLong1, this.matchTernaryMaskLong).build();
    private Criterion sameAsMatchPiTernaryLong1 = PiCriterion.builder().matchTernary(this.ipv4MatchFieldId, this.matchTernaryLong1, this.matchTernaryMaskLong).build();
    private Criterion matchPiTernaryLong2 = PiCriterion.builder().matchTernary(this.ipv4MatchFieldId, this.matchTernaryLong2, this.matchTernaryMaskLong).build();
    private byte[] matchRangeBytes1 = new byte[]{16};
    private byte[] matchRangeBytes2 = new byte[]{32};
    private byte[] matchRangeHighBytes = new byte[]{48};
    private Criterion matchPiRangeByte1 = PiCriterion.builder().matchRange(this.ipv4MatchFieldId, this.matchRangeBytes1, this.matchRangeHighBytes).build();
    private Criterion sameAsMatchPiRangeByte1 = PiCriterion.builder().matchRange(this.ipv4MatchFieldId, this.matchRangeBytes1, this.matchRangeHighBytes).build();
    private Criterion matchPiRangeByte2 = PiCriterion.builder().matchRange(this.ipv4MatchFieldId, this.matchRangeBytes2, this.matchRangeHighBytes).build();
    private short matchRangeShort1 = (short)256;
    private short matchRangeShort2 = (short)512;
    private short matchRangeHighShort = (short)768;
    private Criterion matchPiRangeShort1 = PiCriterion.builder().matchRange(this.ipv4MatchFieldId, this.matchRangeShort1, this.matchRangeHighShort).build();
    private Criterion sameAsMatchPiRangeShort1 = PiCriterion.builder().matchRange(this.ipv4MatchFieldId, this.matchRangeShort1, this.matchRangeHighShort).build();
    private Criterion matchPiRangeShort2 = PiCriterion.builder().matchRange(this.ipv4MatchFieldId, this.matchRangeShort2, this.matchRangeHighShort).build();
    private int matchRangeInt1 = 256;
    private int matchRangeInt2 = 512;
    private int matchRangeHighInt = 768;
    private Criterion matchPiRangeInt1 = PiCriterion.builder().matchRange(this.ipv4MatchFieldId, this.matchRangeInt1, this.matchRangeHighInt).build();
    private Criterion sameAsMatchPiRangeInt1 = PiCriterion.builder().matchRange(this.ipv4MatchFieldId, this.matchRangeInt1, this.matchRangeHighInt).build();
    private Criterion matchPiRangeInt2 = PiCriterion.builder().matchRange(this.ipv4MatchFieldId, this.matchRangeInt2, this.matchRangeHighInt).build();
    private long matchRangeLong1 = 256L;
    private long matchRangeLong2 = 512L;
    private long matchRangeHighLong = 768L;
    private Criterion matchPiRangeLong1 = PiCriterion.builder().matchRange(this.ipv4MatchFieldId, this.matchRangeLong1, this.matchRangeHighLong).build();
    private Criterion sameAsMatchPiRangeLong1 = PiCriterion.builder().matchRange(this.ipv4MatchFieldId, this.matchRangeLong1, this.matchRangeHighLong).build();
    private Criterion matchPiRangeLong2 = PiCriterion.builder().matchRange(this.ipv4MatchFieldId, this.matchRangeLong2, this.matchRangeHighLong).build();

    private <T> T checkAndConvert(Criterion criterion, Criterion.Type type, Class clazz) {
        MatcherAssert.assertThat((Object)criterion, (Matcher)Matchers.is((Matcher)Matchers.notNullValue()));
        MatcherAssert.assertThat((Object)criterion.type(), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)type)));
        MatcherAssert.assertThat((Object)criterion, (Matcher)Matchers.instanceOf((Class)clazz));
        return (T)criterion;
    }

    @Test
    public void testExactMatchPiMethod() {
        PiCriterion matchPiBytes = PiCriterion.builder().matchExact(this.ethMatchFieldId, this.matchExactBytes1).build();
        PiCriterion piCriterionBytes = (PiCriterion)this.checkAndConvert((Criterion)matchPiBytes, Criterion.Type.PROTOCOL_INDEPENDENT, PiCriterion.class);
        PiExactFieldMatch expectedMatchBytes = new PiExactFieldMatch(this.ethMatchFieldId, ImmutableByteSequence.copyFrom((byte[])this.matchExactBytes1));
        MatcherAssert.assertThat((Object)((PiFieldMatch)piCriterionBytes.fieldMatches().iterator().next()), (Matcher)Matchers.is((Object)expectedMatchBytes));
        PiCriterion matchPiShort = PiCriterion.builder().matchExact(this.ethMatchFieldId, this.matchExactShort1).build();
        PiCriterion piCriterionShort = (PiCriterion)this.checkAndConvert((Criterion)matchPiShort, Criterion.Type.PROTOCOL_INDEPENDENT, PiCriterion.class);
        PiExactFieldMatch expectedMatchShort = new PiExactFieldMatch(this.ethMatchFieldId, ImmutableByteSequence.copyFrom((short)this.matchExactShort1));
        MatcherAssert.assertThat((Object)((PiFieldMatch)piCriterionShort.fieldMatches().iterator().next()), (Matcher)Matchers.is((Object)expectedMatchShort));
        PiCriterion matchPiInt = PiCriterion.builder().matchExact(this.ethMatchFieldId, this.matchExactInt1).build();
        PiCriterion piCriterionInt = (PiCriterion)this.checkAndConvert((Criterion)matchPiInt, Criterion.Type.PROTOCOL_INDEPENDENT, PiCriterion.class);
        PiExactFieldMatch expectedMatchInt = new PiExactFieldMatch(this.ethMatchFieldId, ImmutableByteSequence.copyFrom((int)this.matchExactInt1));
        MatcherAssert.assertThat((Object)((PiFieldMatch)piCriterionInt.fieldMatches().iterator().next()), (Matcher)Matchers.is((Object)expectedMatchInt));
        PiCriterion matchPiLong = PiCriterion.builder().matchExact(this.ethMatchFieldId, this.matchExactLong1).build();
        PiCriterion piCriterionLong = (PiCriterion)this.checkAndConvert((Criterion)matchPiLong, Criterion.Type.PROTOCOL_INDEPENDENT, PiCriterion.class);
        PiExactFieldMatch expectedMatchLong = new PiExactFieldMatch(this.ethMatchFieldId, ImmutableByteSequence.copyFrom((long)this.matchExactLong1));
        MatcherAssert.assertThat((Object)((PiFieldMatch)piCriterionLong.fieldMatches().iterator().next()), (Matcher)Matchers.is((Object)expectedMatchLong));
    }

    @Test
    public void testLpmMatchPiMethod() {
        PiCriterion matchPiBytes = PiCriterion.builder().matchLpm(this.ipv4MatchFieldId, this.matchLpmBytes1, this.mask).build();
        PiCriterion piCriterionBytes = (PiCriterion)this.checkAndConvert((Criterion)matchPiBytes, Criterion.Type.PROTOCOL_INDEPENDENT, PiCriterion.class);
        PiLpmFieldMatch expectedMatchBytes = new PiLpmFieldMatch(this.ipv4MatchFieldId, ImmutableByteSequence.copyFrom((byte[])this.matchLpmBytes1), this.mask);
        MatcherAssert.assertThat((Object)((PiFieldMatch)piCriterionBytes.fieldMatches().iterator().next()), (Matcher)Matchers.is((Object)expectedMatchBytes));
        PiCriterion matchPiShort = PiCriterion.builder().matchLpm(this.ipv4MatchFieldId, this.matchLpmShort1, this.mask).build();
        PiCriterion piCriterionShort = (PiCriterion)this.checkAndConvert((Criterion)matchPiShort, Criterion.Type.PROTOCOL_INDEPENDENT, PiCriterion.class);
        PiLpmFieldMatch expectedMatchShort = new PiLpmFieldMatch(this.ipv4MatchFieldId, ImmutableByteSequence.copyFrom((short)this.matchLpmShort1), this.mask);
        MatcherAssert.assertThat((Object)((PiFieldMatch)piCriterionShort.fieldMatches().iterator().next()), (Matcher)Matchers.is((Object)expectedMatchShort));
        PiCriterion matchPiInt = PiCriterion.builder().matchLpm(this.ipv4MatchFieldId, this.matchLpmInt1, this.mask).build();
        PiCriterion piCriterionInt = (PiCriterion)this.checkAndConvert((Criterion)matchPiInt, Criterion.Type.PROTOCOL_INDEPENDENT, PiCriterion.class);
        PiLpmFieldMatch expectedMatchInt = new PiLpmFieldMatch(this.ipv4MatchFieldId, ImmutableByteSequence.copyFrom((int)this.matchLpmInt1), this.mask);
        MatcherAssert.assertThat((Object)((PiFieldMatch)piCriterionInt.fieldMatches().iterator().next()), (Matcher)Matchers.is((Object)expectedMatchInt));
        PiCriterion matchPiLong = PiCriterion.builder().matchLpm(this.ipv4MatchFieldId, this.matchLpmLong1, this.mask).build();
        PiCriterion piCriterionLong = (PiCriterion)this.checkAndConvert((Criterion)matchPiLong, Criterion.Type.PROTOCOL_INDEPENDENT, PiCriterion.class);
        PiLpmFieldMatch expectedMatchLong = new PiLpmFieldMatch(this.ipv4MatchFieldId, ImmutableByteSequence.copyFrom((long)this.matchLpmLong1), this.mask);
        MatcherAssert.assertThat((Object)((PiFieldMatch)piCriterionLong.fieldMatches().iterator().next()), (Matcher)Matchers.is((Object)expectedMatchLong));
    }

    @Test
    public void testTernaryMatchPiMethod() {
        PiCriterion matchPiBytes = PiCriterion.builder().matchTernary(this.ipv4MatchFieldId, this.matchTernaryBytes1, this.matchTernaryMaskBytes).build();
        PiCriterion piCriterionBytes = (PiCriterion)this.checkAndConvert((Criterion)matchPiBytes, Criterion.Type.PROTOCOL_INDEPENDENT, PiCriterion.class);
        PiTernaryFieldMatch expectedMatchBytes = new PiTernaryFieldMatch(this.ipv4MatchFieldId, ImmutableByteSequence.copyFrom((byte[])this.matchTernaryBytes1), ImmutableByteSequence.copyFrom((byte[])this.matchTernaryMaskBytes));
        MatcherAssert.assertThat((Object)((PiFieldMatch)piCriterionBytes.fieldMatches().iterator().next()), (Matcher)Matchers.is((Object)expectedMatchBytes));
        PiCriterion matchPiShort = PiCriterion.builder().matchTernary(this.ipv4MatchFieldId, this.matchTernaryShort1, this.matchTernaryMaskShort).build();
        PiCriterion piCriterionShort = (PiCriterion)this.checkAndConvert((Criterion)matchPiShort, Criterion.Type.PROTOCOL_INDEPENDENT, PiCriterion.class);
        PiTernaryFieldMatch expectedMatchShort = new PiTernaryFieldMatch(this.ipv4MatchFieldId, ImmutableByteSequence.copyFrom((short)this.matchTernaryShort1), ImmutableByteSequence.copyFrom((short)this.matchTernaryMaskShort));
        MatcherAssert.assertThat((Object)((PiFieldMatch)piCriterionShort.fieldMatches().iterator().next()), (Matcher)Matchers.is((Object)expectedMatchShort));
        PiCriterion matchPiInt = PiCriterion.builder().matchTernary(this.ipv4MatchFieldId, this.matchTernaryInt1, this.matchTernaryMaskInt).build();
        PiCriterion piCriterionInt = (PiCriterion)this.checkAndConvert((Criterion)matchPiInt, Criterion.Type.PROTOCOL_INDEPENDENT, PiCriterion.class);
        PiTernaryFieldMatch expectedMatchInt = new PiTernaryFieldMatch(this.ipv4MatchFieldId, ImmutableByteSequence.copyFrom((int)this.matchTernaryInt1), ImmutableByteSequence.copyFrom((int)this.matchTernaryMaskInt));
        MatcherAssert.assertThat((Object)((PiFieldMatch)piCriterionInt.fieldMatches().iterator().next()), (Matcher)Matchers.is((Object)expectedMatchInt));
        PiCriterion matchPiLong = PiCriterion.builder().matchTernary(this.ipv4MatchFieldId, this.matchTernaryLong1, this.matchTernaryMaskLong).build();
        PiCriterion piCriterionLong = (PiCriterion)this.checkAndConvert((Criterion)matchPiLong, Criterion.Type.PROTOCOL_INDEPENDENT, PiCriterion.class);
        PiTernaryFieldMatch expectedMatchLong = new PiTernaryFieldMatch(this.ipv4MatchFieldId, ImmutableByteSequence.copyFrom((long)this.matchTernaryLong1), ImmutableByteSequence.copyFrom((long)this.matchTernaryMaskLong));
        MatcherAssert.assertThat((Object)((PiFieldMatch)piCriterionLong.fieldMatches().iterator().next()), (Matcher)Matchers.is((Object)expectedMatchLong));
    }

    @Test
    public void testRangeMatchPiMethod() {
        PiCriterion matchPiBytes = PiCriterion.builder().matchRange(this.ipv4MatchFieldId, this.matchRangeBytes1, this.matchRangeHighBytes).build();
        PiCriterion piCriterionBytes = (PiCriterion)this.checkAndConvert((Criterion)matchPiBytes, Criterion.Type.PROTOCOL_INDEPENDENT, PiCriterion.class);
        PiRangeFieldMatch expectedMatchBytes = new PiRangeFieldMatch(this.ipv4MatchFieldId, ImmutableByteSequence.copyFrom((byte[])this.matchRangeBytes1), ImmutableByteSequence.copyFrom((byte[])this.matchRangeHighBytes));
        MatcherAssert.assertThat((Object)((PiFieldMatch)piCriterionBytes.fieldMatches().iterator().next()), (Matcher)Matchers.is((Object)expectedMatchBytes));
        PiCriterion matchPiShort = PiCriterion.builder().matchRange(this.ipv4MatchFieldId, this.matchRangeShort1, this.matchRangeHighShort).build();
        PiCriterion piCriterionShort = (PiCriterion)this.checkAndConvert((Criterion)matchPiShort, Criterion.Type.PROTOCOL_INDEPENDENT, PiCriterion.class);
        PiRangeFieldMatch expectedMatchShort = new PiRangeFieldMatch(this.ipv4MatchFieldId, ImmutableByteSequence.copyFrom((short)this.matchRangeShort1), ImmutableByteSequence.copyFrom((short)this.matchRangeHighShort));
        MatcherAssert.assertThat((Object)((PiFieldMatch)piCriterionShort.fieldMatches().iterator().next()), (Matcher)Matchers.is((Object)expectedMatchShort));
        PiCriterion matchPiInt = PiCriterion.builder().matchRange(this.ipv4MatchFieldId, this.matchRangeInt1, this.matchRangeHighInt).build();
        PiCriterion piCriterionInt = (PiCriterion)this.checkAndConvert((Criterion)matchPiInt, Criterion.Type.PROTOCOL_INDEPENDENT, PiCriterion.class);
        PiRangeFieldMatch expectedMatchInt = new PiRangeFieldMatch(this.ipv4MatchFieldId, ImmutableByteSequence.copyFrom((int)this.matchRangeInt1), ImmutableByteSequence.copyFrom((int)this.matchRangeHighInt));
        MatcherAssert.assertThat((Object)((PiFieldMatch)piCriterionInt.fieldMatches().iterator().next()), (Matcher)Matchers.is((Object)expectedMatchInt));
        PiCriterion matchPiLong = PiCriterion.builder().matchRange(this.ipv4MatchFieldId, this.matchRangeLong1, this.matchRangeHighLong).build();
        PiCriterion piCriterionLong = (PiCriterion)this.checkAndConvert((Criterion)matchPiLong, Criterion.Type.PROTOCOL_INDEPENDENT, PiCriterion.class);
        PiRangeFieldMatch expectedMatchLong = new PiRangeFieldMatch(this.ipv4MatchFieldId, ImmutableByteSequence.copyFrom((long)this.matchRangeLong1), ImmutableByteSequence.copyFrom((long)this.matchRangeHighLong));
        MatcherAssert.assertThat((Object)((PiFieldMatch)piCriterionLong.fieldMatches().iterator().next()), (Matcher)Matchers.is((Object)expectedMatchLong));
    }

    @Test
    public void testPiExactCriterionEquals() {
        new EqualsTester().addEqualityGroup(new Object[]{this.matchPiExactByte1, this.sameAsMatchPiExactByte1}).addEqualityGroup(new Object[]{this.matchPiExactByte2}).testEquals();
        new EqualsTester().addEqualityGroup(new Object[]{this.matchPiExactShort1, this.sameAsMatchPiExactShort1}).addEqualityGroup(new Object[]{this.matchPiExactShort2}).testEquals();
        new EqualsTester().addEqualityGroup(new Object[]{this.matchPiExactInt1, this.sameAsMatchPiExactInt1}).addEqualityGroup(new Object[]{this.matchPiExactInt2}).testEquals();
        new EqualsTester().addEqualityGroup(new Object[]{this.matchPiExactLong1, this.sameAsMatchPiExactLong1}).addEqualityGroup(new Object[]{this.matchPiExactLong2}).testEquals();
    }

    @Test
    public void testPiLpmCriterionEquals() {
        new EqualsTester().addEqualityGroup(new Object[]{this.matchPiLpmByte1, this.sameAsMatchPiLpmByte1}).addEqualityGroup(new Object[]{this.matchPiLpmByte2}).testEquals();
        new EqualsTester().addEqualityGroup(new Object[]{this.matchPiLpmShort1, this.sameAsMatchPiLpmShort1}).addEqualityGroup(new Object[]{this.matchPiLpmShort2}).testEquals();
        new EqualsTester().addEqualityGroup(new Object[]{this.matchPiLpmInt1, this.sameAsMatchPiLpmInt1}).addEqualityGroup(new Object[]{this.matchPiLpmInt2}).testEquals();
        new EqualsTester().addEqualityGroup(new Object[]{this.matchPiLpmLong1, this.sameAsMatchPiLpmLong1}).addEqualityGroup(new Object[]{this.matchPiLpmLong2}).testEquals();
    }

    @Test
    public void testPiTernaryCriterionEquals() {
        new EqualsTester().addEqualityGroup(new Object[]{this.matchPiTernaryByte1, this.sameAsMatchPiTernaryByte1}).addEqualityGroup(new Object[]{this.matchPiTernaryByte2}).testEquals();
        new EqualsTester().addEqualityGroup(new Object[]{this.matchPiTernaryShort1, this.sameAsMatchPiTernaryShort1}).addEqualityGroup(new Object[]{this.matchPiTernaryShort2}).testEquals();
        new EqualsTester().addEqualityGroup(new Object[]{this.matchPiTernaryInt1, this.sameAsMatchPiTernaryInt1}).addEqualityGroup(new Object[]{this.matchPiTernaryInt2}).testEquals();
        new EqualsTester().addEqualityGroup(new Object[]{this.matchPiTernaryLong1, this.sameAsMatchPiTernaryLong1}).addEqualityGroup(new Object[]{this.matchPiTernaryLong2}).testEquals();
    }

    @Test
    public void testPiRangeCriterionEquals() {
        new EqualsTester().addEqualityGroup(new Object[]{this.matchPiRangeByte1, this.sameAsMatchPiRangeByte1}).addEqualityGroup(new Object[]{this.matchPiRangeByte2}).testEquals();
        new EqualsTester().addEqualityGroup(new Object[]{this.matchPiRangeShort1, this.sameAsMatchPiRangeShort1}).addEqualityGroup(new Object[]{this.matchPiRangeShort2}).testEquals();
        new EqualsTester().addEqualityGroup(new Object[]{this.matchPiRangeInt1, this.sameAsMatchPiRangeInt1}).addEqualityGroup(new Object[]{this.matchPiRangeInt2}).testEquals();
        new EqualsTester().addEqualityGroup(new Object[]{this.matchPiRangeLong1, this.sameAsMatchPiRangeLong1}).addEqualityGroup(new Object[]{this.matchPiRangeLong2}).testEquals();
    }
}

