/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.ui.topo;

import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.List;
import org.junit.Assert;
import org.junit.Test;
import org.onosproject.ui.AbstractUiTest;
import org.onosproject.ui.topo.LayoutLocation;

public class LayoutLocationTest
extends AbstractUiTest {
    private static final String SOME_ID = "foo";
    private static final String OTHER_ID = "bar";
    private static final double SQRT2 = 1.414;
    private static final double PI = 3.142;
    private static final double ZERO = 0.0;
    private static final String COMPACT_LL_1 = "foo,geo,3.142,1.414";
    private static final String COMPACT_LL_2 = "bar,grid,1.414,3.142";
    private static final String COMPACT_LIST = "foo,geo,3.142,1.414~bar,grid,1.414,3.142";
    private LayoutLocation ll;
    private LayoutLocation ll2;

    @Test
    public void basic() {
        this.ll = LayoutLocation.layoutLocation((String)SOME_ID, (LayoutLocation.Type)LayoutLocation.Type.GRID, (double)1.414, (double)3.142);
        LayoutLocationTest.print(this.ll);
        Assert.assertEquals((String)"bad id", (Object)SOME_ID, (Object)this.ll.id());
        Assert.assertEquals((String)"bad type", (Object)LayoutLocation.Type.GRID, (Object)this.ll.locType());
        Assert.assertEquals((String)"bad Y", (double)1.414, (double)this.ll.latOrY(), (double)9.9E-324);
        Assert.assertEquals((String)"bad X", (double)3.142, (double)this.ll.longOrX(), (double)9.9E-324);
        Assert.assertFalse((String)"bad origin check", (boolean)this.ll.isOrigin());
    }

    @Test
    public void createGeoLocFromStringType() {
        this.ll = LayoutLocation.layoutLocation((String)SOME_ID, (String)"geo", (double)1.414, (double)3.142);
        Assert.assertEquals((String)"bad type - not geo", (Object)LayoutLocation.Type.GEO, (Object)this.ll.locType());
    }

    @Test
    public void createGridLocFromStringType() {
        this.ll = LayoutLocation.layoutLocation((String)SOME_ID, (String)"grid", (double)1.414, (double)3.142);
        Assert.assertEquals((String)"bad type - not grid", (Object)LayoutLocation.Type.GRID, (Object)this.ll.locType());
    }

    @Test
    public void zeroLatitude() {
        this.ll = LayoutLocation.layoutLocation((String)SOME_ID, (LayoutLocation.Type)LayoutLocation.Type.GEO, (double)0.0, (double)3.142);
        Assert.assertFalse((String)"shouldn't be origin for zero latitude", (boolean)this.ll.isOrigin());
    }

    @Test
    public void zeroLongitude() {
        this.ll = LayoutLocation.layoutLocation((String)SOME_ID, (LayoutLocation.Type)LayoutLocation.Type.GEO, (double)3.142, (double)0.0);
        Assert.assertFalse((String)"shouldn't be origin for zero longitude", (boolean)this.ll.isOrigin());
    }

    @Test
    public void origin() {
        this.ll = LayoutLocation.layoutLocation((String)SOME_ID, (LayoutLocation.Type)LayoutLocation.Type.GRID, (double)0.0, (double)0.0);
        Assert.assertTrue((String)"should be origin", (boolean)this.ll.isOrigin());
    }

    @Test(expected=IllegalArgumentException.class)
    public void badType() {
        LayoutLocation.layoutLocation((String)SOME_ID, (String)SOME_ID, (double)0.0, (double)3.142);
    }

    @Test(expected=NullPointerException.class)
    public void nullId() {
        LayoutLocation.layoutLocation(null, (LayoutLocation.Type)LayoutLocation.Type.GRID, (double)3.142, (double)3.142);
    }

    @Test
    public void compactString() {
        this.ll = LayoutLocation.layoutLocation((String)SOME_ID, (LayoutLocation.Type)LayoutLocation.Type.GEO, (double)3.142, (double)1.414);
        String s = this.ll.toCompactListString();
        Assert.assertEquals((String)"wrong compactness", (Object)COMPACT_LL_1, (Object)s);
    }

    @Test
    public void fromCompactStringTest() {
        this.ll = LayoutLocation.fromCompactString((String)COMPACT_LL_1);
        this.verifyLL1(this.ll);
    }

    private void verifyLL1(LayoutLocation ll) {
        Assert.assertEquals((String)"LL1 bad id", (Object)SOME_ID, (Object)ll.id());
        Assert.assertEquals((String)"LL1 bad type", (Object)LayoutLocation.Type.GEO, (Object)ll.locType());
        Assert.assertEquals((String)"LL1 bad Y", (double)3.142, (double)ll.latOrY(), (double)9.9E-324);
        Assert.assertEquals((String)"LL1 bad X", (double)1.414, (double)ll.longOrX(), (double)9.9E-324);
    }

    private void verifyLL2(LayoutLocation ll) {
        Assert.assertEquals((String)"LL1 bad id", (Object)OTHER_ID, (Object)ll.id());
        Assert.assertEquals((String)"LL1 bad type", (Object)LayoutLocation.Type.GRID, (Object)ll.locType());
        Assert.assertEquals((String)"LL1 bad Y", (double)1.414, (double)ll.latOrY(), (double)9.9E-324);
        Assert.assertEquals((String)"LL1 bad X", (double)3.142, (double)ll.longOrX(), (double)9.9E-324);
    }

    @Test(expected=IllegalArgumentException.class)
    public void badCompactTooShort() {
        LayoutLocation.fromCompactString((String)"one,two,three");
    }

    @Test(expected=IllegalArgumentException.class)
    public void badCompactTooLong() {
        LayoutLocation.fromCompactString((String)"one,two,three,4,5");
    }

    @Test(expected=IllegalArgumentException.class)
    public void badCompactNoId() {
        LayoutLocation.fromCompactString((String)",GEO,1,2");
    }

    @Test(expected=IllegalArgumentException.class)
    public void badCompactUnparsableY() {
        LayoutLocation.fromCompactString((String)"foo,GEO,yyy,2.3");
    }

    @Test(expected=IllegalArgumentException.class)
    public void badCompactUnparsableX() {
        LayoutLocation.fromCompactString((String)"foo,GEO,0.2,xxx");
    }

    @Test
    public void toCompactList() {
        this.ll = LayoutLocation.layoutLocation((String)SOME_ID, (LayoutLocation.Type)LayoutLocation.Type.GEO, (double)3.142, (double)1.414);
        this.ll2 = LayoutLocation.layoutLocation((String)OTHER_ID, (LayoutLocation.Type)LayoutLocation.Type.GRID, (double)1.414, (double)3.142);
        String compact = LayoutLocation.toCompactListString((LayoutLocation[])new LayoutLocation[]{this.ll, this.ll2});
        LayoutLocationTest.print(compact);
        Assert.assertEquals((String)"wrong list encoding", (Object)COMPACT_LIST, (Object)compact);
    }

    @Test
    public void toCompactList2() {
        this.ll = LayoutLocation.layoutLocation((String)SOME_ID, (LayoutLocation.Type)LayoutLocation.Type.GEO, (double)3.142, (double)1.414);
        this.ll2 = LayoutLocation.layoutLocation((String)OTHER_ID, (LayoutLocation.Type)LayoutLocation.Type.GRID, (double)1.414, (double)3.142);
        ImmutableList locs = ImmutableList.of((Object)this.ll, (Object)this.ll2);
        String compact = LayoutLocation.toCompactListString((List)locs);
        LayoutLocationTest.print(compact);
        Assert.assertEquals((String)"wrong list encoding", (Object)COMPACT_LIST, (Object)compact);
    }

    @Test
    public void fromCompactList() {
        List locs = LayoutLocation.fromCompactListString((String)COMPACT_LIST);
        this.ll = (LayoutLocation)locs.get(0);
        this.ll2 = (LayoutLocation)locs.get(1);
        this.verifyLL1(this.ll);
        this.verifyLL2(this.ll2);
    }

    @Test
    public void fromCompactListNull() {
        List locs = LayoutLocation.fromCompactListString(null);
        Assert.assertEquals((String)"non-empty list", (long)0L, (long)locs.size());
    }

    @Test
    public void fromCompactListEmpty() {
        List locs = LayoutLocation.fromCompactListString((String)"");
        Assert.assertEquals((String)"non-empty list", (long)0L, (long)locs.size());
    }

    @Test
    public void toCompactListStringNullList() {
        String s = LayoutLocation.toCompactListString((List)null);
        Assert.assertEquals((String)"not empty string", (Object)"", (Object)s);
    }

    @Test
    public void toCompactListStringNullArray() {
        String s = LayoutLocation.toCompactListString((LayoutLocation[])null);
        Assert.assertEquals((String)"not empty string", (Object)"", (Object)s);
    }

    @Test
    public void toCompactListStringEmptyArray() {
        String s = LayoutLocation.toCompactListString((LayoutLocation[])new LayoutLocation[0]);
        Assert.assertEquals((String)"not empty string", (Object)"", (Object)s);
    }

    @Test
    public void toCompactListStringEmptyList() {
        String s = LayoutLocation.toCompactListString(new ArrayList());
        Assert.assertEquals((String)"not empty string", (Object)"", (Object)s);
    }
}

