/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.net.config.basics;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.google.common.annotations.Beta;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.onlab.packet.IpPrefix;
import org.onlab.packet.MacAddress;
import org.onlab.packet.VlanId;
import org.onosproject.net.ConnectPoint;
import org.onosproject.net.config.Config;
import org.onosproject.net.config.ConfigException;
import org.onosproject.net.host.InterfaceIpAddress;
import org.onosproject.net.intf.Interface;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Beta
public class InterfaceConfig
extends Config<ConnectPoint> {
    private static Logger log = LoggerFactory.getLogger(InterfaceConfig.class);
    public static final String NAME = "name";
    public static final String IPS = "ips";
    public static final String MAC = "mac";
    public static final String VLAN = "vlan";
    public static final String VLAN_UNTAGGED = "vlan-untagged";
    public static final String VLAN_TAGGED = "vlan-tagged";
    public static final String VLAN_NATIVE = "vlan-native";
    private static final String CONFIG_VALUE_ERROR = "Error parsing config value";
    private static final String INTF_NULL_ERROR = "Interface cannot be null";
    private static final String INTF_NAME_ERROR = "Interface must have a valid name";

    @Override
    public boolean isValid() {
        for (JsonNode node : this.array) {
            if (!this.hasOnlyFields((ObjectNode)node, NAME, IPS, MAC, VLAN, VLAN_UNTAGGED, VLAN_TAGGED, VLAN_NATIVE)) {
                return false;
            }
            ObjectNode obj = (ObjectNode)node;
            if (!(this.isString(obj, NAME, Config.FieldPresence.OPTIONAL, new String[0]) && this.isMacAddress(obj, MAC, Config.FieldPresence.OPTIONAL) && this.isIntegralNumber(obj, VLAN, Config.FieldPresence.OPTIONAL, 0L, 4095L) && this.isIntegralNumber(obj, VLAN_UNTAGGED, Config.FieldPresence.OPTIONAL, 0L, 4095L) && this.isIntegralNumber(obj, VLAN_NATIVE, Config.FieldPresence.OPTIONAL, 0L, 4095L))) {
                return false;
            }
            for (JsonNode ipNode : node.path(IPS)) {
                if (ipNode.isTextual() && IpPrefix.valueOf((String)ipNode.asText()) != null) continue;
                return false;
            }
            Preconditions.checkArgument((!this.hasField(obj, VLAN_TAGGED) || node.path(VLAN_TAGGED).isArray() && node.path(VLAN_TAGGED).size() >= 1 ? 1 : 0) != 0, (String)"%s must be an array with at least one element", (Object)VLAN_TAGGED);
            for (JsonNode vlanNode : node.path(VLAN_TAGGED)) {
                Preconditions.checkArgument((vlanNode.isInt() && vlanNode.intValue() >= 0 && vlanNode.intValue() <= 4095 ? 1 : 0) != 0, (String)"Invalid VLAN ID %s in %s", (int)vlanNode.intValue(), (Object)VLAN_TAGGED);
            }
            Preconditions.checkArgument((!this.hasField(obj, VLAN_UNTAGGED) || !this.hasField(obj, VLAN_TAGGED) && !this.hasField(obj, VLAN_NATIVE) ? 1 : 0) != 0, (String)"%s and %s should not be used when %s is set", (Object)VLAN_TAGGED, (Object)VLAN_NATIVE, (Object)VLAN_UNTAGGED);
            Preconditions.checkArgument((!this.hasField(obj, VLAN_TAGGED) || !this.hasField(obj, VLAN_UNTAGGED) ? 1 : 0) != 0, (String)"%s should not be used when %s is set", (Object)VLAN_UNTAGGED, (Object)VLAN_TAGGED);
            Preconditions.checkArgument((!this.hasField(obj, VLAN_NATIVE) || this.hasField(obj, VLAN_TAGGED) ? 1 : 0) != 0, (String)"%s should not be used alone without %s", (Object)VLAN_NATIVE, (Object)VLAN_TAGGED);
            Preconditions.checkArgument((!this.hasField(obj, VLAN_NATIVE) || !this.hasField(obj, VLAN_TAGGED) || !this.getVlans((JsonNode)obj, VLAN_TAGGED).contains(this.getVlan((JsonNode)obj, VLAN_NATIVE)) ? 1 : 0) != 0, (String)"%s cannot be one of the VLANs configured in %s", (Object)VLAN_NATIVE, (Object)VLAN_TAGGED);
        }
        return true;
    }

    public Set<Interface> getInterfaces() throws ConfigException {
        HashSet interfaces = Sets.newHashSet();
        try {
            for (JsonNode intfNode : this.array) {
                String name = intfNode.path(NAME).asText(null);
                List<InterfaceIpAddress> ips = this.getIps(intfNode);
                String mac = intfNode.path(MAC).asText();
                MacAddress macAddr = mac.isEmpty() ? null : MacAddress.valueOf((String)mac);
                VlanId vlan = this.getVlan(intfNode, VLAN);
                VlanId vlanUntagged = this.getVlan(intfNode, VLAN_UNTAGGED);
                Set<VlanId> vlanTagged = this.getVlans(intfNode, VLAN_TAGGED);
                VlanId vlanNative = this.getVlan(intfNode, VLAN_NATIVE);
                interfaces.add(new Interface(name, (ConnectPoint)this.subject, ips, macAddr, vlan, vlanUntagged, vlanTagged, vlanNative));
            }
        }
        catch (IllegalArgumentException e) {
            throw new ConfigException(CONFIG_VALUE_ERROR, e);
        }
        return interfaces;
    }

    public void addInterface(Interface intf) {
        Preconditions.checkNotNull((Object)intf, (Object)INTF_NULL_ERROR);
        Preconditions.checkArgument((!intf.name().equals("") ? 1 : 0) != 0, (Object)INTF_NAME_ERROR);
        this.removeInterface(intf.name());
        ObjectNode intfNode = this.array.addObject();
        intfNode.put(NAME, intf.name());
        if (intf.mac() != null) {
            intfNode.put(MAC, intf.mac().toString());
        }
        if (!intf.ipAddressesList().isEmpty()) {
            intfNode.set(IPS, (JsonNode)this.putIps(intf.ipAddressesList()));
        }
        if (!intf.vlan().equals((Object)VlanId.NONE)) {
            intfNode.put(VLAN, intf.vlan().toString());
        }
        if (!intf.vlanUntagged().equals((Object)VlanId.NONE)) {
            intfNode.put(VLAN_UNTAGGED, intf.vlanUntagged().toString());
        }
        if (!intf.vlanTagged().isEmpty()) {
            intfNode.set(VLAN_TAGGED, (JsonNode)this.putVlans(intf.vlanTagged()));
        }
        if (!intf.vlanNative().equals((Object)VlanId.NONE)) {
            intfNode.put(VLAN_NATIVE, intf.vlanNative().toString());
        }
    }

    public void removeInterface(String name) {
        Preconditions.checkNotNull((Object)name, (Object)INTF_NULL_ERROR);
        Preconditions.checkArgument((!name.equals("") ? 1 : 0) != 0, (Object)INTF_NAME_ERROR);
        Iterator it = this.array.iterator();
        while (it.hasNext()) {
            JsonNode node = (JsonNode)it.next();
            if (!node.path(NAME).asText().equals(name)) continue;
            it.remove();
            break;
        }
    }

    private VlanId getVlan(JsonNode node, String path) {
        VlanId vlan = VlanId.NONE;
        if (!node.path(path).isMissingNode()) {
            vlan = VlanId.vlanId((short)Short.valueOf(node.path(path).asText()));
        }
        return vlan;
    }

    private Set<VlanId> getVlans(JsonNode node, String path) {
        ImmutableSet.Builder vlanIdBuilder = ImmutableSet.builder();
        JsonNode vlansNode = node.get(path);
        if (vlansNode != null) {
            vlansNode.forEach(vlanNode -> vlanIdBuilder.add((Object)VlanId.vlanId((short)vlanNode.shortValue())));
        }
        return vlanIdBuilder.build();
    }

    private ArrayNode putVlans(Set<VlanId> vlans) {
        ArrayNode vlanArray = this.mapper.createArrayNode();
        vlans.forEach(vlan -> vlanArray.add((int)vlan.toShort()));
        return vlanArray;
    }

    private List<InterfaceIpAddress> getIps(JsonNode node) {
        ArrayList ips = Lists.newArrayList();
        JsonNode ipsNode = node.get(IPS);
        if (ipsNode != null) {
            ipsNode.forEach(jsonNode -> ips.add(InterfaceIpAddress.valueOf(jsonNode.asText())));
        }
        return ips;
    }

    private ArrayNode putIps(List<InterfaceIpAddress> intfIpAddresses) {
        ArrayNode ipArray = this.mapper.createArrayNode();
        intfIpAddresses.forEach(i -> ipArray.add(i.toString()));
        return ipArray;
    }
}

