/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.net.flow;

import com.google.common.base.Preconditions;
import org.onosproject.net.DeviceId;
import org.onosproject.net.flow.IndexTableId;
import org.onosproject.net.flow.TableId;
import org.onosproject.net.flow.TableStatisticsEntry;

public final class DefaultTableStatisticsEntry
implements TableStatisticsEntry {
    private final DeviceId deviceId;
    private final TableId tableId;
    private final long activeFlowEntries;
    private final long packetsLookedupCount;
    private final long packetsMatchedCount;
    private final long maxSize;
    private static final Long NOT_PRESENT = -1L;

    @Deprecated
    public DefaultTableStatisticsEntry(DeviceId deviceId, int tableId, long activeFlowEntries, long packetsLookedupCount, long packetsMatchedCount) {
        this.deviceId = (DeviceId)Preconditions.checkNotNull((Object)deviceId);
        this.tableId = IndexTableId.of(tableId);
        this.activeFlowEntries = activeFlowEntries;
        this.packetsLookedupCount = packetsLookedupCount;
        this.packetsMatchedCount = packetsMatchedCount;
        this.maxSize = NOT_PRESENT;
    }

    private DefaultTableStatisticsEntry(DeviceId deviceId, TableId tableId, long activeFlowEntries, long packetsLookedupCount, long packetsMatchedCount, long maxSize) {
        this.deviceId = (DeviceId)Preconditions.checkNotNull((Object)deviceId);
        this.tableId = tableId;
        this.activeFlowEntries = activeFlowEntries;
        this.packetsLookedupCount = packetsLookedupCount;
        this.packetsMatchedCount = packetsMatchedCount;
        this.maxSize = maxSize;
    }

    public String toString() {
        return "device: " + this.deviceId + ", tableId: " + this.tableId + ", activeEntries: " + this.activeFlowEntries + ", packetsLookedUp: " + this.packetsLookedupCount + ", packetsMatched: " + this.packetsMatchedCount;
    }

    @Override
    public int tableId() {
        return this.tableId.type() == TableId.Type.INDEX ? ((Integer)((IndexTableId)this.tableId).id()).intValue() : this.tableId.hashCode();
    }

    @Override
    public TableId table() {
        return this.tableId;
    }

    @Override
    public long activeFlowEntries() {
        return this.activeFlowEntries;
    }

    @Override
    public long packetsLookedup() {
        return this.packetsLookedupCount;
    }

    @Override
    public long packetsMatched() {
        return this.packetsMatchedCount;
    }

    @Override
    public DeviceId deviceId() {
        return this.deviceId;
    }

    @Override
    public long maxSize() {
        return this.maxSize;
    }

    @Override
    public boolean hasPacketsLookedup() {
        return this.packetsLookedupCount != NOT_PRESENT;
    }

    @Override
    public boolean hasMaxSize() {
        return this.maxSize != NOT_PRESENT;
    }

    public static Builder builder() {
        return new Builder();
    }

    static /* synthetic */ Long access$000() {
        return NOT_PRESENT;
    }

    public static final class Builder {
        private DeviceId deviceId;
        private TableId tableId;
        private Long activeFlowEntries;
        private Long packetsMatchedCount;
        private Long packetsLookedUpCount = DefaultTableStatisticsEntry.access$000();
        private Long maxSize = DefaultTableStatisticsEntry.access$000();

        public Builder withDeviceId(DeviceId deviceId) {
            this.deviceId = deviceId;
            return this;
        }

        public Builder withTableId(TableId tableId) {
            this.tableId = tableId;
            return this;
        }

        public Builder withActiveFlowEntries(long activeFlowEntries) {
            this.activeFlowEntries = activeFlowEntries;
            return this;
        }

        public Builder withPacketsLookedUpCount(long packetsLookedUpCount) {
            this.packetsLookedUpCount = packetsLookedUpCount;
            return this;
        }

        public Builder withPacketsMatchedCount(long packetsMatchedCount) {
            this.packetsMatchedCount = packetsMatchedCount;
            return this;
        }

        public Builder withMaxSize(long maxSize) {
            this.maxSize = maxSize;
            return this;
        }

        public TableStatisticsEntry build() {
            Preconditions.checkNotNull((Object)this.deviceId, (Object)"DeviceId cannot be null");
            Preconditions.checkNotNull((Object)this.tableId, (Object)"TableId cannot be null");
            Preconditions.checkNotNull((Object)this.activeFlowEntries, (Object)"ActiveFlowEntries cannot be null");
            Preconditions.checkNotNull((Object)this.packetsMatchedCount, (Object)"PacketsMatchedCount cannot be null");
            return new DefaultTableStatisticsEntry(this.deviceId, this.tableId, this.activeFlowEntries, this.packetsLookedUpCount, this.packetsMatchedCount, this.maxSize);
        }
    }
}

