/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.net.pi.runtime;

import com.google.common.annotations.Beta;
import com.google.common.base.MoreObjects;
import com.google.common.base.Objects;
import org.onosproject.net.DeviceId;
import org.onosproject.net.pi.model.PiActionProfileId;
import org.onosproject.net.pi.runtime.PiActionGroup;
import org.onosproject.net.pi.runtime.PiActionGroupId;
import org.onosproject.net.pi.runtime.PiEntityType;
import org.onosproject.net.pi.runtime.PiHandle;

@Beta
public final class PiActionGroupHandle
extends PiHandle<PiActionGroup> {
    private final PiActionProfileId actionProfileId;
    private final PiActionGroupId groupId;

    private PiActionGroupHandle(DeviceId deviceId, PiActionGroup group) {
        super(deviceId);
        this.actionProfileId = group.actionProfileId();
        this.groupId = group.id();
    }

    public static PiActionGroupHandle of(DeviceId deviceId, PiActionGroup group) {
        return new PiActionGroupHandle(deviceId, group);
    }

    @Override
    public PiEntityType entityType() {
        return PiEntityType.GROUP;
    }

    @Override
    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.deviceId(), this.actionProfileId, this.groupId});
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PiActionGroupHandle that = (PiActionGroupHandle)o;
        return Objects.equal((Object)this.deviceId(), (Object)that.deviceId()) && Objects.equal((Object)((Object)this.actionProfileId), (Object)((Object)that.actionProfileId)) && Objects.equal((Object)this.groupId, (Object)that.groupId);
    }

    @Override
    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("deviceId", (Object)this.deviceId()).add("actionProfileId", (Object)this.actionProfileId).add("groupId", (Object)this.groupId).toString();
    }
}

