/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.net.pi.runtime;

import com.google.common.annotations.Beta;
import com.google.common.base.MoreObjects;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import org.onosproject.net.DeviceId;
import org.onosproject.net.pi.runtime.PiEntityType;
import org.onosproject.net.pi.runtime.PiHandle;
import org.onosproject.net.pi.runtime.PiMeterCellConfig;
import org.onosproject.net.pi.runtime.PiMeterCellId;

@Beta
public final class PiMeterHandle
extends PiHandle<PiMeterCellConfig> {
    private final PiMeterCellId cellId;

    private PiMeterHandle(DeviceId deviceId, PiMeterCellId meterCellId) {
        super(deviceId);
        this.cellId = meterCellId;
    }

    public static PiMeterHandle of(DeviceId deviceId, PiMeterCellId meterCellId) {
        return new PiMeterHandle(deviceId, meterCellId);
    }

    public static PiMeterHandle of(DeviceId deviceId, PiMeterCellConfig meterCellConfig) {
        Preconditions.checkNotNull((Object)meterCellConfig);
        return new PiMeterHandle(deviceId, meterCellConfig.cellId());
    }

    @Override
    public PiEntityType entityType() {
        return PiEntityType.METER_CELL_CONFIG;
    }

    @Override
    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.deviceId(), this.cellId});
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PiMeterHandle that = (PiMeterHandle)o;
        return Objects.equal((Object)this.deviceId(), (Object)that.deviceId()) && Objects.equal((Object)this.cellId, (Object)that.cellId);
    }

    @Override
    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("deviceId", (Object)this.deviceId()).add("meterCellId", (Object)this.cellId).toString();
    }
}

