/*
 * Copyright 2015 Open Networking Laboratory
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.onosproject.net.packet;

import org.onosproject.core.ApplicationId;
import org.onosproject.net.flow.FlowRule;
import org.onosproject.net.flow.TrafficSelector;

/**
 * Represents a packet request made to devices.
 */
public interface PacketRequest {

    /**
     * Obtain the traffic selector.
     * @return a traffic selector
     */
    TrafficSelector selector();

    /**
     * Obtain the priority.
     * @return a PacketPriority
     */
    PacketPriority priority();

    /**
     * Obtain the application id.
     * @return an application id
     */
    ApplicationId appId();

    /**
     * Obtain the table type.
     * @return a table type
     */
    FlowRule.Type tableType();

}
