/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.net.driver;

import java.io.IOException;
import java.io.InputStream;
import java.util.Iterator;
import org.junit.Assert;
import org.junit.Test;
import org.onosproject.net.driver.DefaultDriverData;
import org.onosproject.net.driver.DefaultDriverProvider;
import org.onosproject.net.driver.Driver;
import org.onosproject.net.driver.DriverData;
import org.onosproject.net.driver.TestBehaviour;
import org.onosproject.net.driver.XmlDriverLoader;

public class XmlDriverLoaderTest {
    @Test
    public void basics() throws IOException {
        XmlDriverLoader loader = new XmlDriverLoader(this.getClass().getClassLoader());
        InputStream stream = this.getClass().getResourceAsStream("drivers.1.xml");
        DefaultDriverProvider provider = loader.loadDrivers(stream, null);
        System.out.println(provider);
        Assert.assertEquals((String)"incorrect driver count", (long)2L, (long)provider.getDrivers().size());
        Iterator iterator = provider.getDrivers().iterator();
        Driver driver = (Driver)iterator.next();
        if (!driver.name().equals("foo.1")) {
            driver = (Driver)iterator.next();
        }
        Assert.assertEquals((String)"incorrect driver name", (Object)"foo.1", (Object)driver.name());
        Assert.assertEquals((String)"incorrect driver mfg", (Object)"Circus", (Object)driver.manufacturer());
        Assert.assertEquals((String)"incorrect driver hw", (Object)"1.2a", (Object)driver.hwVersion());
        Assert.assertEquals((String)"incorrect driver sw", (Object)"2.2", (Object)driver.swVersion());
        Assert.assertEquals((String)"incorrect driver behaviours", (long)1L, (long)driver.behaviours().size());
        Assert.assertTrue((String)"incorrect driver behaviour", (boolean)driver.hasBehaviour(TestBehaviour.class));
        Assert.assertEquals((String)"incorrect driver properties", (long)2L, (long)driver.properties().size());
        Assert.assertTrue((String)"incorrect driver property", (boolean)driver.properties().containsKey("p1"));
    }

    @Test(expected=IOException.class)
    public void badXML() throws IOException {
        XmlDriverLoader loader = new XmlDriverLoader(this.getClass().getClassLoader());
        loader.loadDrivers(this.getClass().getResourceAsStream("drivers.bad.xml"), null);
    }

    @Test(expected=IllegalArgumentException.class)
    public void noClass() throws IOException {
        XmlDriverLoader loader = new XmlDriverLoader(this.getClass().getClassLoader());
        loader.loadDrivers(this.getClass().getResourceAsStream("drivers.noclass.xml"), null);
    }

    @Test(expected=IllegalArgumentException.class)
    public void noConstructor() throws IOException {
        XmlDriverLoader loader = new XmlDriverLoader(this.getClass().getClassLoader());
        InputStream stream = this.getClass().getResourceAsStream("drivers.noconstructor.xml");
        DefaultDriverProvider provider = loader.loadDrivers(stream, null);
        Driver driver = (Driver)provider.getDrivers().iterator().next();
        driver.createBehaviour((DriverData)new DefaultDriverData(driver), TestBehaviour.class);
    }
}

