/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.net.flow;

import com.google.common.testing.EqualsTester;
import java.util.Set;
import org.hamcrest.Description;
import org.hamcrest.Factory;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.hamcrest.TypeSafeMatcher;
import org.junit.Test;
import org.onlab.junit.ImmutableClassChecker;
import org.onlab.packet.Ip6Address;
import org.onlab.packet.IpPrefix;
import org.onlab.packet.MacAddress;
import org.onlab.packet.MplsLabel;
import org.onlab.packet.VlanId;
import org.onosproject.net.PortNumber;
import org.onosproject.net.flow.DefaultTrafficSelector;
import org.onosproject.net.flow.TrafficSelector;
import org.onosproject.net.flow.criteria.Criteria;
import org.onosproject.net.flow.criteria.Criterion;

public class DefaultTrafficSelectorTest {
    @Test
    public void testImmutability() {
        ImmutableClassChecker.assertThatClassIsImmutable(DefaultTrafficSelector.class);
    }

    @Test
    public void testEquals() {
        boolean one = true;
        int two = 2;
        TrafficSelector selector1 = DefaultTrafficSelector.builder().matchLambda((short)1).build();
        TrafficSelector sameAsSelector1 = DefaultTrafficSelector.builder().matchLambda((short)1).build();
        TrafficSelector selector2 = DefaultTrafficSelector.builder().matchLambda((short)2).build();
        new EqualsTester().addEqualityGroup(new Object[]{selector1, sameAsSelector1}).addEqualityGroup(new Object[]{selector2}).testEquals();
    }

    @Factory
    public static Matcher<TrafficSelector> hasCriterionWithType(Criterion.Type type) {
        return new CriterionExistsMatcher(type);
    }

    @Test
    public void testCriteriaCreation() {
        long longValue = 305419896L;
        int intValue = 22;
        int shortValue = 33;
        int byteValue = 44;
        int dscpValue = 15;
        int ecnValue = 3;
        MacAddress macValue = MacAddress.valueOf((String)"11:22:33:44:55:66");
        IpPrefix ipPrefixValue = IpPrefix.valueOf((String)"192.168.1.0/24");
        IpPrefix ipv6PrefixValue = IpPrefix.valueOf((String)"fe80::1/64");
        Ip6Address ipv6AddressValue = Ip6Address.valueOf((String)"fe80::1");
        TrafficSelector selector = DefaultTrafficSelector.builder().matchInPort(PortNumber.portNumber((long)11L)).build();
        MatcherAssert.assertThat((Object)selector, DefaultTrafficSelectorTest.hasCriterionWithType(Criterion.Type.IN_PORT));
        selector = DefaultTrafficSelector.builder().matchInPhyPort(PortNumber.portNumber((long)11L)).build();
        MatcherAssert.assertThat((Object)selector, DefaultTrafficSelectorTest.hasCriterionWithType(Criterion.Type.IN_PHY_PORT));
        selector = DefaultTrafficSelector.builder().matchMetadata(305419896L).build();
        MatcherAssert.assertThat((Object)selector, DefaultTrafficSelectorTest.hasCriterionWithType(Criterion.Type.METADATA));
        selector = DefaultTrafficSelector.builder().matchEthDst(macValue).build();
        MatcherAssert.assertThat((Object)selector, DefaultTrafficSelectorTest.hasCriterionWithType(Criterion.Type.ETH_DST));
        selector = DefaultTrafficSelector.builder().matchEthSrc(macValue).build();
        MatcherAssert.assertThat((Object)selector, DefaultTrafficSelectorTest.hasCriterionWithType(Criterion.Type.ETH_SRC));
        selector = DefaultTrafficSelector.builder().matchEthType((short)33).build();
        MatcherAssert.assertThat((Object)selector, DefaultTrafficSelectorTest.hasCriterionWithType(Criterion.Type.ETH_TYPE));
        selector = DefaultTrafficSelector.builder().matchVlanId(VlanId.vlanId((short)33)).build();
        MatcherAssert.assertThat((Object)selector, DefaultTrafficSelectorTest.hasCriterionWithType(Criterion.Type.VLAN_VID));
        selector = DefaultTrafficSelector.builder().matchVlanPcp((byte)44).build();
        MatcherAssert.assertThat((Object)selector, DefaultTrafficSelectorTest.hasCriterionWithType(Criterion.Type.VLAN_PCP));
        selector = DefaultTrafficSelector.builder().matchIPDscp((byte)15).build();
        MatcherAssert.assertThat((Object)selector, DefaultTrafficSelectorTest.hasCriterionWithType(Criterion.Type.IP_DSCP));
        selector = DefaultTrafficSelector.builder().matchIPEcn((byte)3).build();
        MatcherAssert.assertThat((Object)selector, DefaultTrafficSelectorTest.hasCriterionWithType(Criterion.Type.IP_ECN));
        selector = DefaultTrafficSelector.builder().matchIPProtocol((byte)44).build();
        MatcherAssert.assertThat((Object)selector, DefaultTrafficSelectorTest.hasCriterionWithType(Criterion.Type.IP_PROTO));
        selector = DefaultTrafficSelector.builder().matchIPSrc(ipPrefixValue).build();
        MatcherAssert.assertThat((Object)selector, DefaultTrafficSelectorTest.hasCriterionWithType(Criterion.Type.IPV4_SRC));
        selector = DefaultTrafficSelector.builder().matchIPDst(ipPrefixValue).build();
        MatcherAssert.assertThat((Object)selector, DefaultTrafficSelectorTest.hasCriterionWithType(Criterion.Type.IPV4_DST));
        selector = DefaultTrafficSelector.builder().matchTcpSrc((short)33).build();
        MatcherAssert.assertThat((Object)selector, DefaultTrafficSelectorTest.hasCriterionWithType(Criterion.Type.TCP_SRC));
        selector = DefaultTrafficSelector.builder().matchTcpDst((short)33).build();
        MatcherAssert.assertThat((Object)selector, DefaultTrafficSelectorTest.hasCriterionWithType(Criterion.Type.TCP_DST));
        selector = DefaultTrafficSelector.builder().matchUdpSrc((short)33).build();
        MatcherAssert.assertThat((Object)selector, DefaultTrafficSelectorTest.hasCriterionWithType(Criterion.Type.UDP_SRC));
        selector = DefaultTrafficSelector.builder().matchUdpDst((short)33).build();
        MatcherAssert.assertThat((Object)selector, DefaultTrafficSelectorTest.hasCriterionWithType(Criterion.Type.UDP_DST));
        selector = DefaultTrafficSelector.builder().matchSctpSrc((short)33).build();
        MatcherAssert.assertThat((Object)selector, DefaultTrafficSelectorTest.hasCriterionWithType(Criterion.Type.SCTP_SRC));
        selector = DefaultTrafficSelector.builder().matchSctpDst((short)33).build();
        MatcherAssert.assertThat((Object)selector, DefaultTrafficSelectorTest.hasCriterionWithType(Criterion.Type.SCTP_DST));
        selector = DefaultTrafficSelector.builder().matchIcmpType((byte)44).build();
        MatcherAssert.assertThat((Object)selector, DefaultTrafficSelectorTest.hasCriterionWithType(Criterion.Type.ICMPV4_TYPE));
        selector = DefaultTrafficSelector.builder().matchIcmpCode((byte)44).build();
        MatcherAssert.assertThat((Object)selector, DefaultTrafficSelectorTest.hasCriterionWithType(Criterion.Type.ICMPV4_CODE));
        selector = DefaultTrafficSelector.builder().matchIPv6Src(ipv6PrefixValue).build();
        MatcherAssert.assertThat((Object)selector, DefaultTrafficSelectorTest.hasCriterionWithType(Criterion.Type.IPV6_SRC));
        selector = DefaultTrafficSelector.builder().matchIPv6Dst(ipv6PrefixValue).build();
        MatcherAssert.assertThat((Object)selector, DefaultTrafficSelectorTest.hasCriterionWithType(Criterion.Type.IPV6_DST));
        selector = DefaultTrafficSelector.builder().matchIPv6FlowLabel(22).build();
        MatcherAssert.assertThat((Object)selector, DefaultTrafficSelectorTest.hasCriterionWithType(Criterion.Type.IPV6_FLABEL));
        selector = DefaultTrafficSelector.builder().matchIcmpv6Type((byte)44).build();
        MatcherAssert.assertThat((Object)selector, DefaultTrafficSelectorTest.hasCriterionWithType(Criterion.Type.ICMPV6_TYPE));
        selector = DefaultTrafficSelector.builder().matchIPv6NDTargetAddress(ipv6AddressValue).build();
        MatcherAssert.assertThat((Object)selector, DefaultTrafficSelectorTest.hasCriterionWithType(Criterion.Type.IPV6_ND_TARGET));
        selector = DefaultTrafficSelector.builder().matchIPv6NDSourceLinkLayerAddress(macValue).build();
        MatcherAssert.assertThat((Object)selector, DefaultTrafficSelectorTest.hasCriterionWithType(Criterion.Type.IPV6_ND_SLL));
        selector = DefaultTrafficSelector.builder().matchIPv6NDTargetLinkLayerAddress(macValue).build();
        MatcherAssert.assertThat((Object)selector, DefaultTrafficSelectorTest.hasCriterionWithType(Criterion.Type.IPV6_ND_TLL));
        selector = DefaultTrafficSelector.builder().matchMplsLabel(MplsLabel.mplsLabel((int)3)).build();
        MatcherAssert.assertThat((Object)selector, DefaultTrafficSelectorTest.hasCriterionWithType(Criterion.Type.MPLS_LABEL));
        selector = DefaultTrafficSelector.builder().matchIPv6ExthdrFlags(Criterion.IPv6ExthdrFlags.NONEXT.getValue()).build();
        MatcherAssert.assertThat((Object)selector, DefaultTrafficSelectorTest.hasCriterionWithType(Criterion.Type.IPV6_EXTHDR));
        selector = DefaultTrafficSelector.builder().matchLambda((short)33).build();
        MatcherAssert.assertThat((Object)selector, DefaultTrafficSelectorTest.hasCriterionWithType(Criterion.Type.OCH_SIGID));
        selector = DefaultTrafficSelector.builder().matchOpticalSignalType((short)33).build();
        MatcherAssert.assertThat((Object)selector, DefaultTrafficSelectorTest.hasCriterionWithType(Criterion.Type.OCH_SIGTYPE));
    }

    @Test
    public void testTrafficSelectorBuilder() {
        int shortValue = 33;
        TrafficSelector baseSelector = DefaultTrafficSelector.builder().matchLambda((short)33).build();
        TrafficSelector selector = DefaultTrafficSelector.builder((TrafficSelector)baseSelector).build();
        MatcherAssert.assertThat((Object)selector, DefaultTrafficSelectorTest.hasCriterionWithType(Criterion.Type.OCH_SIGID));
        Criterion criterion = Criteria.matchLambda((int)33);
        selector = DefaultTrafficSelector.builder().add(criterion).build();
        MatcherAssert.assertThat((Object)selector, DefaultTrafficSelectorTest.hasCriterionWithType(Criterion.Type.OCH_SIGID));
    }

    public static final class CriterionExistsMatcher
    extends TypeSafeMatcher<TrafficSelector> {
        private final Criterion.Type type;

        public CriterionExistsMatcher(Criterion.Type typeValue) {
            this.type = typeValue;
        }

        public boolean matchesSafely(TrafficSelector selector) {
            Set criteria = selector.criteria();
            return Matchers.notNullValue().matches((Object)criteria) && Matchers.hasSize((int)1).matches((Object)criteria) && Matchers.notNullValue().matches((Object)selector.getCriterion(this.type));
        }

        public void describeTo(Description description) {
            description.appendText("a criterion with type \" ").appendText(this.type.toString()).appendText("\"");
        }
    }
}

