/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.net.flow;

import com.google.common.testing.EqualsTester;
import java.util.List;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Test;
import org.onlab.packet.IpAddress;
import org.onlab.packet.MacAddress;
import org.onlab.packet.VlanId;
import org.onosproject.net.PortNumber;
import org.onosproject.net.flow.DefaultTrafficTreatment;
import org.onosproject.net.flow.TrafficTreatment;
import org.onosproject.net.flow.instructions.Instruction;
import org.onosproject.net.flow.instructions.Instructions;
import org.onosproject.net.flow.instructions.L0ModificationInstruction;

public class DefaultTrafficTreatmentTest {
    @Test
    public void testTreatmentBuilderConstructors() {
        TrafficTreatment treatment1 = DefaultTrafficTreatment.builder().add((Instruction)Instructions.modL0Lambda((short)4)).build();
        TrafficTreatment treatment2 = DefaultTrafficTreatment.builder((TrafficTreatment)treatment1).build();
        MatcherAssert.assertThat((Object)treatment1, (Matcher)Matchers.is((Matcher)CoreMatchers.equalTo((Object)treatment2)));
    }

    @Test
    public void testBuilderMethods() {
        L0ModificationInstruction instruction1 = Instructions.modL0Lambda((short)4);
        TrafficTreatment.Builder builder1 = DefaultTrafficTreatment.builder().add((Instruction)instruction1).setEthDst(MacAddress.BROADCAST).setEthSrc(MacAddress.BROADCAST).setIpDst(IpAddress.valueOf((String)"1.1.1.1")).setIpSrc(IpAddress.valueOf((String)"2.2.2.2")).setLambda((short)4).setOutput(PortNumber.portNumber((long)2L)).setVlanId(VlanId.vlanId((short)4)).setVlanPcp(Byte.valueOf((byte)3));
        TrafficTreatment treatment1 = builder1.build();
        List instructions1 = treatment1.immediate();
        MatcherAssert.assertThat((Object)instructions1, (Matcher)Matchers.hasSize((int)9));
        builder1.drop();
        builder1.add((Instruction)instruction1);
        List instructions2 = builder1.build().immediate();
        MatcherAssert.assertThat((Object)instructions2, (Matcher)Matchers.hasSize((int)11));
        builder1.deferred().popVlan().pushVlan().setVlanId(VlanId.vlanId((short)5));
        List instructions3 = builder1.build().immediate();
        MatcherAssert.assertThat((Object)instructions3, (Matcher)Matchers.hasSize((int)11));
        List instructions4 = builder1.build().deferred();
        MatcherAssert.assertThat((Object)instructions4, (Matcher)Matchers.hasSize((int)3));
    }

    @Test
    public void testEquals() {
        TrafficTreatment treatment1 = DefaultTrafficTreatment.builder().add((Instruction)Instructions.modL0Lambda((short)4)).build();
        TrafficTreatment sameAsTreatment1 = DefaultTrafficTreatment.builder().add((Instruction)Instructions.modL0Lambda((short)4)).build();
        TrafficTreatment treatment2 = DefaultTrafficTreatment.builder().add((Instruction)Instructions.modL0Lambda((short)2)).build();
        new EqualsTester().addEqualityGroup(new Object[]{treatment1, sameAsTreatment1}).addEqualityGroup(new Object[]{treatment2}).testEquals();
    }
}

