/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.net.host;

import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Test;
import org.onlab.packet.IpAddress;
import org.onlab.packet.IpPrefix;
import org.onosproject.net.host.InterfaceIpAddress;

public class InterfaceIpAddressTest {
    private static final IpAddress IP_ADDRESS = IpAddress.valueOf((String)"1.2.3.4");
    private static final IpPrefix SUBNET_ADDRESS = IpPrefix.valueOf((String)"1.2.0.0/16");
    private static final IpAddress BROADCAST_ADDRESS = IpAddress.valueOf((String)"1.2.0.255");
    private static final IpAddress PEER_ADDRESS = IpAddress.valueOf((String)"5.6.7.8");
    private static final IpAddress IP_ADDRESS2 = IpAddress.valueOf((String)"10.2.3.4");
    private static final IpPrefix SUBNET_ADDRESS2 = IpPrefix.valueOf((String)"10.2.0.0/16");
    private static final IpAddress BROADCAST_ADDRESS2 = IpAddress.valueOf((String)"10.2.0.255");
    private static final IpAddress PEER_ADDRESS2 = IpAddress.valueOf((String)"50.6.7.8");

    @Test
    public void testCopyConstructor() {
        InterfaceIpAddress fromAddr = new InterfaceIpAddress(IP_ADDRESS, SUBNET_ADDRESS);
        InterfaceIpAddress toAddr = new InterfaceIpAddress(fromAddr);
        Assert.assertThat((Object)toAddr.toString(), (Matcher)Matchers.is((Object)"InterfaceIpAddress{ipAddress=1.2.3.4, subnetAddress=1.2.0.0/16}"));
        fromAddr = new InterfaceIpAddress(IP_ADDRESS, SUBNET_ADDRESS, BROADCAST_ADDRESS);
        toAddr = new InterfaceIpAddress(fromAddr);
        Assert.assertThat((Object)toAddr.toString(), (Matcher)Matchers.is((Object)"InterfaceIpAddress{ipAddress=1.2.3.4, subnetAddress=1.2.0.0/16, broadcastAddress=1.2.0.255}"));
        fromAddr = new InterfaceIpAddress(IP_ADDRESS, SUBNET_ADDRESS, null, PEER_ADDRESS);
        toAddr = new InterfaceIpAddress(fromAddr);
        Assert.assertThat((Object)toAddr.toString(), (Matcher)Matchers.is((Object)"InterfaceIpAddress{ipAddress=1.2.3.4, subnetAddress=1.2.0.0/16, peerAddress=5.6.7.8}"));
    }

    @Test(expected=NullPointerException.class)
    public void testInvalidConstructorNullObject() {
        InterfaceIpAddress fromAddr = null;
        InterfaceIpAddress toAddr = new InterfaceIpAddress(fromAddr);
    }

    @Test
    public void testConstructorForDefaultBroadcastAddress() {
        InterfaceIpAddress addr = new InterfaceIpAddress(IP_ADDRESS, SUBNET_ADDRESS);
        Assert.assertThat((Object)addr.toString(), (Matcher)Matchers.is((Object)"InterfaceIpAddress{ipAddress=1.2.3.4, subnetAddress=1.2.0.0/16}"));
    }

    @Test
    public void testConstructorForNonDefaultBroadcastAddress() {
        InterfaceIpAddress addr = new InterfaceIpAddress(IP_ADDRESS, SUBNET_ADDRESS, BROADCAST_ADDRESS);
        Assert.assertThat((Object)addr.toString(), (Matcher)Matchers.is((Object)"InterfaceIpAddress{ipAddress=1.2.3.4, subnetAddress=1.2.0.0/16, broadcastAddress=1.2.0.255}"));
    }

    @Test
    public void testConstructorForPointToPointAddress() {
        InterfaceIpAddress addr = new InterfaceIpAddress(IP_ADDRESS, SUBNET_ADDRESS, null, PEER_ADDRESS);
        Assert.assertThat((Object)addr.toString(), (Matcher)Matchers.is((Object)"InterfaceIpAddress{ipAddress=1.2.3.4, subnetAddress=1.2.0.0/16, peerAddress=5.6.7.8}"));
    }

    @Test
    public void testGetFields() {
        InterfaceIpAddress addr = new InterfaceIpAddress(IP_ADDRESS, SUBNET_ADDRESS);
        Assert.assertThat((Object)addr.ipAddress().toString(), (Matcher)Matchers.is((Object)"1.2.3.4"));
        Assert.assertThat((Object)addr.subnetAddress().toString(), (Matcher)Matchers.is((Object)"1.2.0.0/16"));
        Assert.assertThat((Object)addr.broadcastAddress(), (Matcher)Matchers.is((Matcher)Matchers.nullValue()));
        Assert.assertThat((Object)addr.peerAddress(), (Matcher)Matchers.is((Matcher)Matchers.nullValue()));
        addr = new InterfaceIpAddress(IP_ADDRESS, SUBNET_ADDRESS, BROADCAST_ADDRESS);
        Assert.assertThat((Object)addr.ipAddress().toString(), (Matcher)Matchers.is((Object)"1.2.3.4"));
        Assert.assertThat((Object)addr.subnetAddress().toString(), (Matcher)Matchers.is((Object)"1.2.0.0/16"));
        Assert.assertThat((Object)addr.broadcastAddress().toString(), (Matcher)Matchers.is((Object)"1.2.0.255"));
        Assert.assertThat((Object)addr.peerAddress(), (Matcher)Matchers.is((Matcher)Matchers.nullValue()));
        addr = new InterfaceIpAddress(IP_ADDRESS, SUBNET_ADDRESS, null, PEER_ADDRESS);
        Assert.assertThat((Object)addr.ipAddress().toString(), (Matcher)Matchers.is((Object)"1.2.3.4"));
        Assert.assertThat((Object)addr.subnetAddress().toString(), (Matcher)Matchers.is((Object)"1.2.0.0/16"));
        Assert.assertThat((Object)addr.broadcastAddress(), (Matcher)Matchers.is((Matcher)Matchers.nullValue()));
        Assert.assertThat((Object)addr.peerAddress().toString(), (Matcher)Matchers.is((Object)"5.6.7.8"));
    }

    @Test
    public void testEquality() {
        InterfaceIpAddress addr1 = new InterfaceIpAddress(IP_ADDRESS, SUBNET_ADDRESS);
        InterfaceIpAddress addr2 = new InterfaceIpAddress(IP_ADDRESS, SUBNET_ADDRESS);
        Assert.assertThat((Object)addr1, (Matcher)Matchers.is((Object)addr2));
        addr1 = new InterfaceIpAddress(IP_ADDRESS, SUBNET_ADDRESS, BROADCAST_ADDRESS);
        addr2 = new InterfaceIpAddress(IP_ADDRESS, SUBNET_ADDRESS, BROADCAST_ADDRESS);
        Assert.assertThat((Object)addr1, (Matcher)Matchers.is((Object)addr2));
        addr1 = new InterfaceIpAddress(IP_ADDRESS, SUBNET_ADDRESS, null, PEER_ADDRESS);
        addr2 = new InterfaceIpAddress(IP_ADDRESS, SUBNET_ADDRESS, null, PEER_ADDRESS);
        Assert.assertThat((Object)addr1, (Matcher)Matchers.is((Object)addr2));
    }

    @Test
    public void testNonEquality() {
        InterfaceIpAddress addr1 = new InterfaceIpAddress(IP_ADDRESS, SUBNET_ADDRESS);
        InterfaceIpAddress addr2 = new InterfaceIpAddress(IP_ADDRESS, SUBNET_ADDRESS, BROADCAST_ADDRESS);
        InterfaceIpAddress addr3 = new InterfaceIpAddress(IP_ADDRESS, SUBNET_ADDRESS, null, PEER_ADDRESS);
        Assert.assertThat((Object)addr1, (Matcher)Matchers.is((Matcher)Matchers.not((Object)addr2)));
        Assert.assertThat((Object)addr1, (Matcher)Matchers.is((Matcher)Matchers.not((Object)addr3)));
        Assert.assertThat((Object)addr2, (Matcher)Matchers.is((Matcher)Matchers.not((Object)addr3)));
        InterfaceIpAddress addr4 = new InterfaceIpAddress(IP_ADDRESS2, SUBNET_ADDRESS);
        Assert.assertThat((Object)addr1, (Matcher)Matchers.is((Matcher)Matchers.not((Object)addr4)));
        addr4 = new InterfaceIpAddress(IP_ADDRESS, SUBNET_ADDRESS2);
        Assert.assertThat((Object)addr1, (Matcher)Matchers.is((Matcher)Matchers.not((Object)addr4)));
        addr4 = new InterfaceIpAddress(IP_ADDRESS2, SUBNET_ADDRESS, BROADCAST_ADDRESS);
        Assert.assertThat((Object)addr2, (Matcher)Matchers.is((Matcher)Matchers.not((Object)addr4)));
        addr4 = new InterfaceIpAddress(IP_ADDRESS, SUBNET_ADDRESS2, BROADCAST_ADDRESS);
        Assert.assertThat((Object)addr2, (Matcher)Matchers.is((Matcher)Matchers.not((Object)addr4)));
        addr4 = new InterfaceIpAddress(IP_ADDRESS, SUBNET_ADDRESS, BROADCAST_ADDRESS2);
        Assert.assertThat((Object)addr2, (Matcher)Matchers.is((Matcher)Matchers.not((Object)addr4)));
        addr4 = new InterfaceIpAddress(IP_ADDRESS2, SUBNET_ADDRESS, null, PEER_ADDRESS);
        Assert.assertThat((Object)addr3, (Matcher)Matchers.is((Matcher)Matchers.not((Object)addr4)));
        addr4 = new InterfaceIpAddress(IP_ADDRESS, SUBNET_ADDRESS2, null, PEER_ADDRESS);
        Assert.assertThat((Object)addr3, (Matcher)Matchers.is((Matcher)Matchers.not((Object)addr4)));
        addr4 = new InterfaceIpAddress(IP_ADDRESS, SUBNET_ADDRESS, null, PEER_ADDRESS2);
        Assert.assertThat((Object)addr3, (Matcher)Matchers.is((Matcher)Matchers.not((Object)addr4)));
    }

    @Test
    public void testToString() {
        InterfaceIpAddress addr = new InterfaceIpAddress(IP_ADDRESS, SUBNET_ADDRESS);
        Assert.assertThat((Object)addr.toString(), (Matcher)Matchers.is((Object)"InterfaceIpAddress{ipAddress=1.2.3.4, subnetAddress=1.2.0.0/16}"));
        addr = new InterfaceIpAddress(IP_ADDRESS, SUBNET_ADDRESS, BROADCAST_ADDRESS);
        Assert.assertThat((Object)addr.toString(), (Matcher)Matchers.is((Object)"InterfaceIpAddress{ipAddress=1.2.3.4, subnetAddress=1.2.0.0/16, broadcastAddress=1.2.0.255}"));
        addr = new InterfaceIpAddress(IP_ADDRESS, SUBNET_ADDRESS, null, PEER_ADDRESS);
        Assert.assertThat((Object)addr.toString(), (Matcher)Matchers.is((Object)"InterfaceIpAddress{ipAddress=1.2.3.4, subnetAddress=1.2.0.0/16, peerAddress=5.6.7.8}"));
    }
}

