/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.net.host;

import com.google.common.collect.ImmutableSet;
import com.google.common.testing.EqualsTester;
import java.util.Set;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Before;
import org.junit.Test;
import org.onlab.junit.ImmutableClassChecker;
import org.onlab.packet.IpAddress;
import org.onlab.packet.IpPrefix;
import org.onlab.packet.MacAddress;
import org.onlab.packet.VlanId;
import org.onosproject.net.ConnectPoint;
import org.onosproject.net.NetTestTools;
import org.onosproject.net.host.InterfaceIpAddress;
import org.onosproject.net.host.PortAddresses;

public class PortAddressesTest {
    PortAddresses addresses1;
    PortAddresses sameAsAddresses1;
    PortAddresses addresses2;
    PortAddresses addresses3;
    private static final ConnectPoint CONNECT_POINT1 = NetTestTools.connectPoint("cp1", 1);
    private static final IpAddress IP_ADDRESS1 = IpAddress.valueOf((String)"1.2.3.4");
    private static final IpPrefix SUBNET_ADDRESS1 = IpPrefix.valueOf((String)"1.2.0.0/16");
    private static final InterfaceIpAddress INTERFACE_ADDRESS_1 = new InterfaceIpAddress(IP_ADDRESS1, SUBNET_ADDRESS1);
    private static final ConnectPoint CONNECT_POINT2 = NetTestTools.connectPoint("cp2", 1);
    private static final IpAddress IP_ADDRESS2 = IpAddress.valueOf((String)"1.2.3.5");
    private static final IpPrefix SUBNET_ADDRESS2 = IpPrefix.valueOf((String)"1.3.0.0/16");
    private static final InterfaceIpAddress INTERFACE_ADDRESS_2 = new InterfaceIpAddress(IP_ADDRESS2, SUBNET_ADDRESS2);
    Set<InterfaceIpAddress> ipAddresses;

    @Before
    public void setUpAddresses() {
        this.ipAddresses = ImmutableSet.of((Object)INTERFACE_ADDRESS_1, (Object)INTERFACE_ADDRESS_2);
        this.addresses1 = new PortAddresses(CONNECT_POINT1, this.ipAddresses, MacAddress.BROADCAST, VlanId.NONE);
        this.sameAsAddresses1 = new PortAddresses(CONNECT_POINT1, this.ipAddresses, MacAddress.BROADCAST, VlanId.NONE);
        this.addresses2 = new PortAddresses(CONNECT_POINT2, this.ipAddresses, MacAddress.BROADCAST, VlanId.NONE);
        this.addresses3 = new PortAddresses(CONNECT_POINT2, this.ipAddresses, MacAddress.ZERO, VlanId.NONE);
    }

    @Test
    public void testImmutability() {
        ImmutableClassChecker.assertThatClassIsImmutable(PortAddresses.class);
    }

    @Test
    public void testEquals() {
        new EqualsTester().addEqualityGroup(new Object[]{this.addresses1, this.sameAsAddresses1}).addEqualityGroup(new Object[]{this.addresses2}).addEqualityGroup(new Object[]{this.addresses3}).testEquals();
    }

    @Test
    public void testConstruction() {
        MatcherAssert.assertThat((Object)this.addresses1.mac(), (Matcher)Matchers.is((Object)MacAddress.BROADCAST));
        MatcherAssert.assertThat((Object)this.addresses1.connectPoint(), (Matcher)Matchers.is((Object)CONNECT_POINT1));
        MatcherAssert.assertThat((Object)this.addresses1.ipAddresses(), (Matcher)Matchers.is(this.ipAddresses));
        MatcherAssert.assertThat((Object)this.addresses1.vlan(), (Matcher)Matchers.is((Object)VlanId.NONE));
    }
}

