/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.net.intent;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.onosproject.event.Event;
import org.onosproject.net.intent.Intent;
import org.onosproject.net.intent.IntentCompiler;
import org.onosproject.net.intent.IntentData;
import org.onosproject.net.intent.IntentEvent;
import org.onosproject.net.intent.IntentException;
import org.onosproject.net.intent.IntentListener;
import org.onosproject.net.intent.IntentState;
import org.onosproject.net.intent.Key;
import org.onosproject.net.intent.TestableIntentService;

public class FakeIntentManager
implements TestableIntentService {
    private final Map<Key, Intent> intents = new HashMap<Key, Intent>();
    private final Map<Key, IntentState> intentStates = new HashMap<Key, IntentState>();
    private final Map<Key, List<Intent>> installables = new HashMap<Key, List<Intent>>();
    private final Set<IntentListener> listeners = new HashSet<IntentListener>();
    private final Map<Class<? extends Intent>, IntentCompiler<? extends Intent>> compilers = new HashMap<Class<? extends Intent>, IntentCompiler<? extends Intent>>();
    private final ExecutorService executor = Executors.newSingleThreadExecutor();
    private final List<IntentException> exceptions = new ArrayList<IntentException>();

    @Override
    public List<IntentException> getExceptions() {
        return this.exceptions;
    }

    private void executeSubmit(final Intent intent) {
        this.registerSubclassCompilerIfNeeded(intent);
        this.executor.execute(new Runnable(){

            @Override
            public void run() {
                try {
                    FakeIntentManager.this.executeCompilingPhase(intent);
                }
                catch (IntentException e) {
                    FakeIntentManager.this.exceptions.add(e);
                }
            }
        });
    }

    private void executeWithdraw(final Intent intent) {
        this.executor.execute(new Runnable(){

            @Override
            public void run() {
                try {
                    List installable = FakeIntentManager.this.getInstallable(intent.key());
                    FakeIntentManager.this.executeWithdrawingPhase(intent, installable);
                }
                catch (IntentException e) {
                    FakeIntentManager.this.exceptions.add(e);
                }
            }
        });
    }

    private <T extends Intent> IntentCompiler<T> getCompiler(T intent) {
        IntentCompiler<? extends Intent> compiler = this.compilers.get(intent.getClass());
        if (compiler == null) {
            throw new IntentException("no compiler for class " + intent.getClass());
        }
        return compiler;
    }

    private <T extends Intent> void executeCompilingPhase(T intent) {
        this.setState(intent, IntentState.COMPILING);
        try {
            ArrayList<Intent> installable = new ArrayList<Intent>();
            for (Intent compiled : this.getCompiler(intent).compile(intent, null, null)) {
                installable.add(compiled);
            }
            this.executeInstallingPhase(intent, installable);
        }
        catch (IntentException e) {
            this.setState(intent, IntentState.FAILED);
            this.dispatch(new IntentEvent(IntentEvent.Type.FAILED, intent));
        }
    }

    private void executeInstallingPhase(Intent intent, List<Intent> installable) {
        this.setState(intent, IntentState.INSTALLING);
        try {
            this.setState(intent, IntentState.INSTALLED);
            this.putInstallable(intent.key(), installable);
            this.dispatch(new IntentEvent(IntentEvent.Type.INSTALLED, intent));
        }
        catch (IntentException e) {
            this.setState(intent, IntentState.FAILED);
            this.dispatch(new IntentEvent(IntentEvent.Type.FAILED, intent));
        }
    }

    private void executeWithdrawingPhase(Intent intent, List<Intent> installable) {
        this.setState(intent, IntentState.WITHDRAWING);
        try {
            this.removeInstallable(intent.key());
            this.setState(intent, IntentState.WITHDRAWN);
            this.dispatch(new IntentEvent(IntentEvent.Type.WITHDRAWN, intent));
        }
        catch (IntentException e) {
            this.setState(intent, IntentState.FAILED);
            this.dispatch(new IntentEvent(IntentEvent.Type.FAILED, intent));
        }
    }

    private void setState(Intent intent, IntentState state) {
        this.intentStates.put(intent.key(), state);
    }

    private void putInstallable(Key key, List<Intent> installable) {
        this.installables.put(key, installable);
    }

    private void removeInstallable(Key key) {
        this.installables.remove(key);
    }

    private List<Intent> getInstallable(Key key) {
        List<Intent> installable = this.installables.get(key);
        if (installable != null) {
            return installable;
        }
        return Collections.emptyList();
    }

    public void submit(Intent intent) {
        this.intents.put(intent.key(), intent);
        this.setState(intent, IntentState.INSTALL_REQ);
        this.dispatch(new IntentEvent(IntentEvent.Type.INSTALL_REQ, intent));
        this.executeSubmit(intent);
    }

    public void withdraw(Intent intent) {
        this.intents.remove(intent.key());
        this.executeWithdraw(intent);
    }

    public void purge(Intent intent) {
        IntentState currentState = this.intentStates.get(intent.key());
        if (currentState == IntentState.WITHDRAWN || currentState == IntentState.FAILED) {
            this.intents.remove(intent.key());
            this.installables.remove(intent.key());
            this.intentStates.remove(intent.key());
        }
    }

    public Set<Intent> getIntents() {
        return Collections.unmodifiableSet(new HashSet<Intent>(this.intents.values()));
    }

    public Iterable<IntentData> getIntentData() {
        throw new UnsupportedOperationException();
    }

    public long getIntentCount() {
        return this.intents.size();
    }

    public Intent getIntent(Key intentKey) {
        return this.intents.get(intentKey);
    }

    public IntentState getIntentState(Key intentKey) {
        return this.intentStates.get(intentKey);
    }

    public List<Intent> getInstallableIntents(Key intentKey) {
        return this.installables.get(intentKey);
    }

    public boolean isLocal(Key intentKey) {
        return true;
    }

    public Iterable<Intent> getPending() {
        return Collections.emptyList();
    }

    public void addListener(IntentListener listener) {
        this.listeners.add(listener);
    }

    public void removeListener(IntentListener listener) {
        this.listeners.remove(listener);
    }

    private void dispatch(IntentEvent event) {
        for (IntentListener listener : this.listeners) {
            listener.event((Event)event);
        }
    }

    public <T extends Intent> void registerCompiler(Class<T> cls, IntentCompiler<T> compiler) {
        this.compilers.put(cls, compiler);
    }

    public <T extends Intent> void unregisterCompiler(Class<T> cls) {
        this.compilers.remove(cls);
    }

    public Map<Class<? extends Intent>, IntentCompiler<? extends Intent>> getCompilers() {
        return Collections.unmodifiableMap(this.compilers);
    }

    private void registerSubclassCompilerIfNeeded(Intent intent) {
        if (!this.compilers.containsKey(intent.getClass())) {
            for (Class<?> cls = intent.getClass(); cls != Object.class; cls = cls.getSuperclass()) {
                IntentCompiler<? extends Intent> compiler;
                if (!Intent.class.isAssignableFrom(cls) || (compiler = this.compilers.get(cls)) == null) continue;
                this.compilers.put(intent.getClass(), compiler);
                return;
            }
        }
    }
}

