/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.net.intent;

import com.google.common.testing.EqualsTester;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Test;
import org.onlab.junit.ImmutableClassChecker;
import org.onosproject.TestApplicationId;
import org.onosproject.core.ApplicationId;
import org.onosproject.net.HostId;
import org.onosproject.net.NetTestTools;
import org.onosproject.net.flow.TrafficSelector;
import org.onosproject.net.flow.TrafficTreatment;
import org.onosproject.net.intent.HostToHostIntent;
import org.onosproject.net.intent.Intent;
import org.onosproject.net.intent.IntentTest;
import org.onosproject.net.intent.IntentTestsMocks;

public class HostToHostIntentTest
extends IntentTest {
    private final TrafficSelector selector = new IntentTestsMocks.MockSelector();
    private final IntentTestsMocks.MockTreatment treatment = new IntentTestsMocks.MockTreatment();
    private final HostId id1 = NetTestTools.hid("12:34:56:78:91:ab/1");
    private final HostId id2 = NetTestTools.hid("12:34:56:78:92:ab/1");
    private final HostId id3 = NetTestTools.hid("12:34:56:78:93:ab/1");
    private static final ApplicationId APPID = new TestApplicationId("foo");

    private HostToHostIntent makeHostToHost(HostId one, HostId two) {
        return HostToHostIntent.builder().appId(APPID).one(one).two(two).selector(this.selector).treatment((TrafficTreatment)this.treatment).build();
    }

    @Test
    public void testSameEquals() {
        HostId one = NetTestTools.hid("00:00:00:00:00:01/-1");
        HostId two = NetTestTools.hid("00:00:00:00:00:02/-1");
        HostToHostIntent i1 = this.makeHostToHost(one, two);
        HostToHostIntent i2 = this.makeHostToHost(one, two);
        MatcherAssert.assertThat((Object)i1.one(), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)i2.one())));
        MatcherAssert.assertThat((Object)i1.two(), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)i2.two())));
    }

    @Test
    public void testImmutability() {
        ImmutableClassChecker.assertThatClassIsImmutable(HostToHostIntent.class);
    }

    @Test
    public void testEquals() {
        HostToHostIntent intent1 = HostToHostIntent.builder().appId(APPID).one(this.id1).two(this.id2).selector(this.selector).treatment((TrafficTreatment)this.treatment).build();
        HostToHostIntent intent2 = HostToHostIntent.builder().appId(APPID).one(this.id2).two(this.id3).selector(this.selector).treatment((TrafficTreatment)this.treatment).build();
        new EqualsTester().addEqualityGroup(new Object[]{intent1}).addEqualityGroup(new Object[]{intent2}).testEquals();
    }

    @Override
    protected Intent createOne() {
        return HostToHostIntent.builder().appId(APPID).one(this.id1).two(this.id2).selector(this.selector).treatment((TrafficTreatment)this.treatment).build();
    }

    @Override
    protected Intent createAnother() {
        return HostToHostIntent.builder().appId(APPID).one(this.id1).two(this.id3).selector(this.selector).treatment((TrafficTreatment)this.treatment).build();
    }
}

