/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.net.intent;

import com.google.common.collect.ImmutableSet;
import com.google.common.testing.EqualsTester;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Test;
import org.onlab.junit.ImmutableClassChecker;
import org.onosproject.net.ConnectPoint;
import org.onosproject.net.Link;
import org.onosproject.net.NetTestTools;
import org.onosproject.net.flow.TrafficSelector;
import org.onosproject.net.flow.TrafficTreatment;
import org.onosproject.net.intent.Constraint;
import org.onosproject.net.intent.Intent;
import org.onosproject.net.intent.IntentTest;
import org.onosproject.net.intent.IntentTestsMocks;
import org.onosproject.net.intent.LinkCollectionIntent;
import org.onosproject.net.intent.constraint.LambdaConstraint;
import org.onosproject.net.resource.link.LambdaResource;

public class LinkCollectionIntentTest
extends IntentTest {
    final ConnectPoint ingress = NetTestTools.connectPoint("ingress", 2);
    final ConnectPoint egress = NetTestTools.connectPoint("egress", 3);
    final TrafficSelector selector = new IntentTestsMocks.MockSelector();
    final IntentTestsMocks.MockTreatment treatment = new IntentTestsMocks.MockTreatment();

    @Test
    public void testImmutability() {
        ImmutableClassChecker.assertThatClassIsImmutable(LinkCollectionIntent.class);
    }

    @Test
    public void testEquals() {
        HashSet<Link> links1 = new HashSet<Link>();
        links1.add(NetTestTools.link("src", 1, "dst", 2));
        LinkCollectionIntent collectionIntent1 = LinkCollectionIntent.builder().appId(NetTestTools.APP_ID).selector(this.selector).treatment((TrafficTreatment)this.treatment).links(links1).ingressPoints((Set)ImmutableSet.of((Object)this.ingress)).egressPoints((Set)ImmutableSet.of((Object)this.egress)).build();
        HashSet<Link> links2 = new HashSet<Link>();
        links2.add(NetTestTools.link("src", 1, "dst", 3));
        LinkCollectionIntent collectionIntent2 = LinkCollectionIntent.builder().appId(NetTestTools.APP_ID).selector(this.selector).treatment((TrafficTreatment)this.treatment).links(links2).ingressPoints((Set)ImmutableSet.of((Object)this.ingress)).egressPoints((Set)ImmutableSet.of((Object)this.egress)).build();
        new EqualsTester().addEqualityGroup(new Object[]{collectionIntent1}).addEqualityGroup(new Object[]{collectionIntent2}).testEquals();
    }

    @Test
    public void testConstructor() {
        HashSet<Link> links1 = new HashSet<Link>();
        links1.add(NetTestTools.link("src", 1, "dst", 2));
        LinkCollectionIntent collectionIntent = LinkCollectionIntent.builder().appId(NetTestTools.APP_ID).selector(this.selector).treatment((TrafficTreatment)this.treatment).links(links1).ingressPoints((Set)ImmutableSet.of((Object)this.ingress)).egressPoints((Set)ImmutableSet.of((Object)this.egress)).build();
        Set createdLinks = collectionIntent.links();
        MatcherAssert.assertThat((Object)createdLinks, (Matcher)Matchers.hasSize((int)1));
        MatcherAssert.assertThat((Object)collectionIntent.isInstallable(), (Matcher)Matchers.is((Object)false));
        MatcherAssert.assertThat((Object)collectionIntent.treatment(), (Matcher)Matchers.is((Object)this.treatment));
        MatcherAssert.assertThat((Object)collectionIntent.selector(), (Matcher)Matchers.is((Object)this.selector));
        MatcherAssert.assertThat((Object)collectionIntent.ingressPoints(), (Matcher)Matchers.is((Object)ImmutableSet.of((Object)this.ingress)));
        MatcherAssert.assertThat((Object)collectionIntent.egressPoints(), (Matcher)Matchers.is((Object)ImmutableSet.of((Object)this.egress)));
        MatcherAssert.assertThat((Object)collectionIntent.resources(), (Matcher)Matchers.hasSize((int)1));
        List createdConstraints = collectionIntent.constraints();
        MatcherAssert.assertThat((Object)createdConstraints, (Matcher)Matchers.hasSize((int)0));
    }

    @Test
    public void testConstructorWithConstraints() {
        HashSet<Link> links1 = new HashSet<Link>();
        LinkedList<LambdaConstraint> constraints = new LinkedList<LambdaConstraint>();
        links1.add(NetTestTools.link("src", 1, "dst", 2));
        constraints.add(new LambdaConstraint(LambdaResource.valueOf((int)23)));
        LinkCollectionIntent collectionIntent = LinkCollectionIntent.builder().appId(NetTestTools.APP_ID).selector(this.selector).treatment((TrafficTreatment)this.treatment).links(links1).ingressPoints((Set)ImmutableSet.of((Object)this.ingress)).egressPoints((Set)ImmutableSet.of((Object)this.egress)).constraints(constraints).priority(8888).build();
        Set createdLinks = collectionIntent.links();
        MatcherAssert.assertThat((Object)createdLinks, (Matcher)Matchers.hasSize((int)1));
        MatcherAssert.assertThat((Object)collectionIntent.isInstallable(), (Matcher)Matchers.is((Object)false));
        MatcherAssert.assertThat((Object)collectionIntent.treatment(), (Matcher)Matchers.is((Object)this.treatment));
        MatcherAssert.assertThat((Object)collectionIntent.selector(), (Matcher)Matchers.is((Object)this.selector));
        MatcherAssert.assertThat((Object)collectionIntent.ingressPoints(), (Matcher)Matchers.is((Object)ImmutableSet.of((Object)this.ingress)));
        MatcherAssert.assertThat((Object)collectionIntent.egressPoints(), (Matcher)Matchers.is((Object)ImmutableSet.of((Object)this.egress)));
        List createdConstraints = collectionIntent.constraints();
        MatcherAssert.assertThat((Object)createdConstraints, (Matcher)Matchers.hasSize((int)1));
        MatcherAssert.assertThat((Object)((Constraint)createdConstraints.get(0)).toString(), (Matcher)Matchers.startsWith((String)"LambdaConstraint"));
    }

    @Test
    public void testSerializerConstructor() {
        LinkCollectionIntent collectionIntent = new LinkCollectionIntent();
        Set createdLinks = collectionIntent.links();
        MatcherAssert.assertThat((Object)createdLinks, (Matcher)Matchers.nullValue());
        MatcherAssert.assertThat((Object)collectionIntent.isInstallable(), (Matcher)Matchers.is((Object)false));
        MatcherAssert.assertThat((Object)collectionIntent.treatment(), (Matcher)Matchers.nullValue());
        MatcherAssert.assertThat((Object)collectionIntent.selector(), (Matcher)Matchers.nullValue());
        MatcherAssert.assertThat((Object)collectionIntent.ingressPoints(), (Matcher)Matchers.nullValue());
        MatcherAssert.assertThat((Object)collectionIntent.egressPoints(), (Matcher)Matchers.nullValue());
        List createdConstraints = collectionIntent.constraints();
        MatcherAssert.assertThat((Object)createdConstraints, (Matcher)Matchers.hasSize((int)0));
    }

    @Override
    protected Intent createOne() {
        HashSet<Link> links1 = new HashSet<Link>();
        links1.add(NetTestTools.link("src", 1, "dst", 2));
        return LinkCollectionIntent.builder().appId(NetTestTools.APP_ID).selector(this.selector).treatment((TrafficTreatment)this.treatment).links(links1).ingressPoints((Set)ImmutableSet.of((Object)this.ingress)).egressPoints((Set)ImmutableSet.of((Object)this.egress)).build();
    }

    @Override
    protected Intent createAnother() {
        HashSet<Link> links2 = new HashSet<Link>();
        links2.add(NetTestTools.link("src", 1, "dst", 3));
        return LinkCollectionIntent.builder().appId(NetTestTools.APP_ID).selector(this.selector).treatment((TrafficTreatment)this.treatment).links(links2).ingressPoints((Set)ImmutableSet.of((Object)this.ingress)).egressPoints((Set)ImmutableSet.of((Object)this.egress)).build();
    }
}

