/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.net.intent;

import com.google.common.testing.EqualsTester;
import java.util.Optional;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.hamcrest.core.IsEqual;
import org.junit.Before;
import org.junit.Test;
import org.onlab.junit.ImmutableClassChecker;
import org.onlab.packet.MplsLabel;
import org.onosproject.net.NetTestTools;
import org.onosproject.net.Path;
import org.onosproject.net.flow.TrafficSelector;
import org.onosproject.net.flow.TrafficTreatment;
import org.onosproject.net.intent.AbstractIntentTest;
import org.onosproject.net.intent.IntentTestsMocks;
import org.onosproject.net.intent.MplsPathIntent;

public class MplsPathIntentTest
extends AbstractIntentTest {
    static final int PRIORITY = 777;
    MplsPathIntent intent1;
    MplsPathIntent intent2;
    Path defaultPath;
    Optional<MplsLabel> label1;
    Optional<MplsLabel> label2;
    TrafficSelector selector;
    TrafficTreatment treatment;

    @Before
    public void mplsPathIntentTestSetUp() {
        this.defaultPath = NetTestTools.createPath("a", "b", "c");
        this.selector = new IntentTestsMocks.MockSelector();
        this.treatment = new IntentTestsMocks.MockTreatment();
        this.label1 = Optional.of(MplsLabel.mplsLabel((int)1));
        this.label2 = Optional.of(MplsLabel.mplsLabel((int)2));
        this.intent1 = MplsPathIntent.builder().appId(NetTestTools.APP_ID).ingressLabel(this.label1).egressLabel(this.label2).path(this.defaultPath).priority(777).build();
        this.intent2 = MplsPathIntent.builder().appId(NetTestTools.APP_ID).ingressLabel(this.label1).egressLabel(this.label2).path(this.defaultPath).priority(777).build();
    }

    @Test
    public void testImmutability() {
        ImmutableClassChecker.assertThatClassIsImmutable(MplsPathIntent.class);
    }

    @Test
    public void testEquals() {
        new EqualsTester().addEqualityGroup(new Object[]{this.intent1}).addEqualityGroup(new Object[]{this.intent2}).testEquals();
    }

    @Test
    public void testContents() {
        MatcherAssert.assertThat((Object)this.intent1.appId(), (Matcher)IsEqual.equalTo((Object)NetTestTools.APP_ID));
        MatcherAssert.assertThat((Object)this.intent1.ingressLabel(), (Matcher)IsEqual.equalTo(this.label1));
        MatcherAssert.assertThat((Object)this.intent1.egressLabel(), (Matcher)IsEqual.equalTo(this.label2));
        MatcherAssert.assertThat((Object)this.intent1.selector(), (Matcher)IsEqual.equalTo((Object)this.intent2.selector()));
        MatcherAssert.assertThat((Object)this.intent1.treatment(), (Matcher)IsEqual.equalTo((Object)this.intent2.treatment()));
        MatcherAssert.assertThat((Object)this.intent1.priority(), (Matcher)Matchers.is((Object)777));
        MatcherAssert.assertThat((Object)this.intent1.path(), (Matcher)Matchers.is((Object)this.defaultPath));
    }
}

