/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.net.intent.constraint;

import com.google.common.testing.EqualsTester;
import java.util.Arrays;
import org.easymock.EasyMock;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.onosproject.net.Annotations;
import org.onosproject.net.DefaultLink;
import org.onosproject.net.DefaultLinkTest;
import org.onosproject.net.DefaultPath;
import org.onosproject.net.DeviceId;
import org.onosproject.net.ElementId;
import org.onosproject.net.Link;
import org.onosproject.net.Path;
import org.onosproject.net.PortNumber;
import org.onosproject.net.intent.constraint.ObstacleConstraint;
import org.onosproject.net.provider.ProviderId;
import org.onosproject.net.resource.link.LinkResourceService;

public class ObstacleConstraintTest {
    private static final DeviceId DID1 = DeviceId.deviceId((String)"of:1");
    private static final DeviceId DID2 = DeviceId.deviceId((String)"of:2");
    private static final DeviceId DID3 = DeviceId.deviceId((String)"of:3");
    private static final DeviceId DID4 = DeviceId.deviceId((String)"of:4");
    private static final PortNumber PN1 = PortNumber.portNumber((long)1L);
    private static final PortNumber PN2 = PortNumber.portNumber((long)2L);
    private static final PortNumber PN3 = PortNumber.portNumber((long)3L);
    private static final PortNumber PN4 = PortNumber.portNumber((long)4L);
    private static final ProviderId PROVIDER_ID = new ProviderId("of", "foo");
    private LinkResourceService linkResourceService;
    private Path path;
    private DefaultLink link2;
    private DefaultLink link1;
    private ObstacleConstraint sut;

    @Before
    public void setUp() {
        this.linkResourceService = (LinkResourceService)EasyMock.createMock(LinkResourceService.class);
        this.link1 = new DefaultLink(PROVIDER_ID, DefaultLinkTest.cp((ElementId)DID1, PN1), DefaultLinkTest.cp((ElementId)DID2, PN2), Link.Type.DIRECT, new Annotations[0]);
        this.link2 = new DefaultLink(PROVIDER_ID, DefaultLinkTest.cp((ElementId)DID2, PN3), DefaultLinkTest.cp((ElementId)DID3, PN4), Link.Type.DIRECT, new Annotations[0]);
        this.path = new DefaultPath(PROVIDER_ID, Arrays.asList(this.link1, this.link2), 10.0, new Annotations[0]);
    }

    @Test
    public void testEquality() {
        ObstacleConstraint o1 = new ObstacleConstraint(new DeviceId[]{DID1, DID2, DID3});
        ObstacleConstraint o2 = new ObstacleConstraint(new DeviceId[]{DID3, DID2, DID1});
        ObstacleConstraint o3 = new ObstacleConstraint(new DeviceId[]{DID1, DID2});
        ObstacleConstraint o4 = new ObstacleConstraint(new DeviceId[]{DID2, DID1});
        new EqualsTester().addEqualityGroup(new Object[]{o1, o2}).addEqualityGroup(new Object[]{o3, o4}).testEquals();
    }

    @Test
    public void testPathNotThroughObstacles() {
        this.sut = new ObstacleConstraint(new DeviceId[]{DID4});
        Assert.assertThat((Object)this.sut.validate(this.path, this.linkResourceService), (Matcher)Matchers.is((Object)true));
    }

    @Test
    public void testPathThroughObstacle() {
        this.sut = new ObstacleConstraint(new DeviceId[]{DID1});
        Assert.assertThat((Object)this.sut.validate(this.path, this.linkResourceService), (Matcher)Matchers.is((Object)false));
    }
}

