/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.ui;

import com.google.common.collect.ImmutableList;
import com.google.common.io.ByteStreams;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import org.junit.Assert;
import org.junit.Test;
import org.onosproject.ui.UiExtension;
import org.onosproject.ui.UiView;

public class UiExtensionTest {
    @Test
    public void basics() throws IOException {
        UiExtension ext = new UiExtension((List)ImmutableList.of((Object)new UiView(UiView.Category.OTHER, "foo", "Foo View")), null, this.getClass().getClassLoader());
        String css = new String(ByteStreams.toByteArray((InputStream)ext.css()));
        Assert.assertTrue((String)"incorrect css stream", (boolean)css.contains("foo-css"));
        String js = new String(ByteStreams.toByteArray((InputStream)ext.js()));
        Assert.assertTrue((String)"incorrect js stream", (boolean)js.contains("foo-js"));
        Assert.assertEquals((String)"incorrect view id", (Object)"foo", (Object)((UiView)ext.views().get(0)).id());
        Assert.assertEquals((String)"incorrect view category", (Object)UiView.Category.OTHER, (Object)((UiView)ext.views().get(0)).category());
        Assert.assertNull((String)"incorrect handler factory", (Object)ext.messageHandlerFactory());
    }

    @Test
    public void withPath() throws IOException {
        UiExtension ext = new UiExtension((List)ImmutableList.of((Object)new UiView(UiView.Category.OTHER, "foo", "Foo View")), null, "custom", this.getClass().getClassLoader());
        String css = new String(ByteStreams.toByteArray((InputStream)ext.css()));
        Assert.assertTrue((String)"incorrect css stream", (boolean)css.contains("custom-css"));
        String js = new String(ByteStreams.toByteArray((InputStream)ext.js()));
        Assert.assertTrue((String)"incorrect js stream", (boolean)js.contains("custom-js"));
        Assert.assertEquals((String)"incorrect view id", (Object)"foo", (Object)((UiView)ext.views().get(0)).id());
        Assert.assertNull((String)"incorrect handler factory", (Object)ext.messageHandlerFactory());
    }
}

