/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.ui.table;

import org.junit.Assert;
import org.junit.Test;
import org.onosproject.ui.table.CellFormatter;
import org.onosproject.ui.table.TableModel;
import org.onosproject.ui.table.cell.DefaultCellFormatter;
import org.onosproject.ui.table.cell.HexFormatter;

public class TableModelTest {
    private static final String UNEX_SORT = "unexpected sort: index ";
    private static final String FOO = "foo";
    private static final String BAR = "bar";
    private static final String ZOO = "zoo";
    private TableModel tm;
    private TableModel.Row[] rows;
    private TableModel.Row row;
    private CellFormatter fmt;
    private static final String ONE = "one";
    private static final String TWO = "two";
    private static final String THREE = "three";
    private static final String FOUR = "four";
    private static final String ELEVEN = "eleven";
    private static final String TWELVE = "twelve";
    private static final String TWENTY = "twenty";
    private static final String THIRTY = "thirty";
    private static final String[] NAMES = new String[]{"four", "three", "two", "one", "eleven", "twelve", "thirty", "twenty"};
    private static final String[] SORTED_NAMES = new String[]{"eleven", "four", "one", "thirty", "three", "twelve", "twenty", "two"};
    private static final int[] NUMBERS = new int[]{4, 3, 2, 1, 11, 12, 30, 20};
    private static final int[] SORTED_NUMBERS = new int[]{1, 2, 3, 4, 11, 12, 20, 30};
    private static final String[] SORTED_HEX = new String[]{"0x1", "0x2", "0x3", "0x4", "0xb", "0xc", "0x14", "0x1e"};
    private static final String[][] SORTED_NAMES_AND_HEX = new String[][]{{"eleven", "0xb"}, {"four", "0x4"}, {"one", "0x1"}, {"thirty", "0x1e"}, {"three", "0x3"}, {"twelve", "0xc"}, {"twenty", "0x14"}, {"two", "0x2"}};
    private static final String[] FBZ = new String[]{"foo", "bar", "zoo"};

    @Test(expected=NullPointerException.class)
    public void guardAgainstNull() {
        this.tm = new TableModel(null);
    }

    @Test(expected=IllegalArgumentException.class)
    public void guardAgainstEmpty() {
        this.tm = new TableModel(new String[0]);
    }

    @Test(expected=IllegalArgumentException.class)
    public void guardAgainstDuplicateCols() {
        this.tm = new TableModel(new String[]{FOO, BAR, FOO});
    }

    @Test
    public void basic() {
        this.tm = new TableModel(new String[]{FOO, BAR});
        Assert.assertEquals((String)"column count", (long)2L, (long)this.tm.columnCount());
        Assert.assertEquals((String)"row count", (long)0L, (long)this.tm.rowCount());
    }

    @Test
    public void defaultFormatter() {
        this.tm = new TableModel(new String[]{FOO});
        this.fmt = this.tm.getFormatter(FOO);
        Assert.assertTrue((String)"Wrong formatter", (boolean)(this.fmt instanceof DefaultCellFormatter));
    }

    @Test(expected=IllegalArgumentException.class)
    public void formatterBadColumn() {
        this.tm = new TableModel(new String[]{FOO});
        this.fmt = this.tm.getFormatter(BAR);
    }

    @Test
    public void altFormatter() {
        this.tm = new TableModel(new String[]{FOO, BAR});
        this.tm.setFormatter(BAR, (CellFormatter)new ParenFormatter());
        this.fmt = this.tm.getFormatter(FOO);
        Assert.assertTrue((String)"Wrong formatter", (boolean)(this.fmt instanceof DefaultCellFormatter));
        Assert.assertEquals((String)"Wrong result", (Object)"2", (Object)this.fmt.format((Object)2));
        this.fmt = this.tm.getFormatter(BAR);
        Assert.assertTrue((String)"Wrong formatter", (boolean)(this.fmt instanceof ParenFormatter));
        Assert.assertEquals((String)"Wrong result", (Object)"(2)", (Object)this.fmt.format((Object)2));
    }

    @Test
    public void emptyRow() {
        this.tm = new TableModel(new String[]{FOO, BAR});
        this.tm.addRow();
        Assert.assertEquals((String)"bad row count", (long)1L, (long)this.tm.rowCount());
    }

    @Test(expected=IllegalArgumentException.class)
    public void rowBadColumn() {
        this.tm = new TableModel(new String[]{FOO, BAR});
        this.tm.addRow().cell(ZOO, (Object)2);
    }

    @Test
    public void simpleRow() {
        this.tm = new TableModel(new String[]{FOO, BAR});
        this.tm.addRow().cell(FOO, (Object)3).cell(BAR, (Object)true);
        Assert.assertEquals((String)"bad row count", (long)1L, (long)this.tm.rowCount());
        this.row = this.tm.getRows()[0];
        Assert.assertEquals((String)"bad cell", (Object)3, (Object)this.row.get(FOO));
        Assert.assertEquals((String)"bad cell", (Object)true, (Object)this.row.get(BAR));
    }

    @Test
    public void verifyTestData() {
        int nalen = NAMES.length;
        int snlen = SORTED_NAMES.length;
        int nulen = NUMBERS.length;
        if (nalen != snlen || nalen != nulen) {
            Assert.fail((String)"test data array size discrepancy");
        }
    }

    private void initUnsortedTable() {
        this.tm = new TableModel(new String[]{FOO, BAR});
        for (int i = 0; i < NAMES.length; ++i) {
            this.tm.addRow().cell(FOO, (Object)NAMES[i]).cell(BAR, (Object)NUMBERS[i]);
        }
    }

    @Test
    public void tableStringSort() {
        int i;
        this.initUnsortedTable();
        this.tm.sort(FOO, TableModel.SortDir.ASC);
        this.rows = this.tm.getRows();
        int nr = this.rows.length;
        Assert.assertEquals((String)"row count", (long)NAMES.length, (long)nr);
        for (i = 0; i < nr; ++i) {
            Assert.assertEquals((String)(UNEX_SORT + i), (Object)SORTED_NAMES[i], (Object)this.rows[i].get(FOO));
        }
        this.tm.sort(FOO, TableModel.SortDir.DESC);
        this.rows = this.tm.getRows();
        nr = this.rows.length;
        Assert.assertEquals((String)"row count", (long)NAMES.length, (long)nr);
        for (i = 0; i < nr; ++i) {
            Assert.assertEquals((String)(UNEX_SORT + i), (Object)SORTED_NAMES[nr - 1 - i], (Object)this.rows[i].get(FOO));
        }
    }

    @Test
    public void tableNumberSort() {
        int i;
        this.initUnsortedTable();
        this.tm.sort(BAR, TableModel.SortDir.ASC);
        this.rows = this.tm.getRows();
        int nr = this.rows.length;
        Assert.assertEquals((String)"row count", (long)NUMBERS.length, (long)nr);
        for (i = 0; i < nr; ++i) {
            Assert.assertEquals((String)(UNEX_SORT + i), (Object)SORTED_NUMBERS[i], (Object)this.rows[i].get(BAR));
        }
        this.tm.sort(BAR, TableModel.SortDir.DESC);
        this.rows = this.tm.getRows();
        nr = this.rows.length;
        Assert.assertEquals((String)"row count", (long)NUMBERS.length, (long)nr);
        for (i = 0; i < nr; ++i) {
            Assert.assertEquals((String)(UNEX_SORT + i), (Object)SORTED_NUMBERS[nr - 1 - i], (Object)this.rows[i].get(BAR));
        }
    }

    @Test
    public void sortAndFormat() {
        this.initUnsortedTable();
        this.tm.setFormatter(BAR, HexFormatter.INSTANCE);
        this.tm.sort(BAR, TableModel.SortDir.ASC);
        this.rows = this.tm.getRows();
        int nr = this.rows.length;
        Assert.assertEquals((String)"row count", (long)SORTED_HEX.length, (long)nr);
        for (int i = 0; i < nr; ++i) {
            Assert.assertEquals((String)(UNEX_SORT + i), (Object)SORTED_HEX[i], (Object)this.rows[i].getAsString(BAR));
        }
    }

    @Test
    public void sortAndFormatTwo() {
        this.initUnsortedTable();
        this.tm.setFormatter(BAR, HexFormatter.INSTANCE);
        this.tm.sort(FOO, TableModel.SortDir.ASC);
        this.rows = this.tm.getRows();
        int nr = this.rows.length;
        for (int i = 0; i < nr; ++i) {
            Object[] exp = SORTED_NAMES_AND_HEX[i];
            Object[] act = this.rows[i].getAsFormattedStrings();
            Assert.assertArrayEquals((String)(UNEX_SORT + i), (Object[])exp, (Object[])act);
        }
    }

    @Test
    public void getColumnIds() {
        this.tm = new TableModel(new String[]{FOO, BAR, ZOO});
        Assert.assertArrayEquals((String)"col IDs", (Object[])FBZ, (Object[])this.tm.getColumnIds());
    }

    @Test
    public void sortDirAsc() {
        Assert.assertEquals((String)"asc sort dir", (Object)TableModel.SortDir.ASC, (Object)TableModel.sortDir((String)"asc"));
    }

    @Test
    public void sortDirDesc() {
        Assert.assertEquals((String)"desc sort dir", (Object)TableModel.SortDir.DESC, (Object)TableModel.sortDir((String)"desc"));
    }

    @Test
    public void sortDirOther() {
        Assert.assertEquals((String)"other sort dir", (Object)TableModel.SortDir.ASC, (Object)TableModel.sortDir((String)"other"));
    }

    @Test
    public void sortDirNull() {
        Assert.assertEquals((String)"null sort dir", (Object)TableModel.SortDir.ASC, (Object)TableModel.sortDir(null));
    }

    @Test
    public void enumSort() {
        this.tm = new TableModel(new String[]{FOO});
        this.tm.addRow().cell(FOO, (Object)StarWars.HAN_SOLO);
        this.tm.addRow().cell(FOO, (Object)StarWars.C3PO);
        this.tm.addRow().cell(FOO, (Object)StarWars.JABBA_THE_HUTT);
        this.tm.addRow().cell(FOO, (Object)StarWars.LEIA_ORGANA);
        this.tm.addRow().cell(FOO, (Object)StarWars.R2D2);
        this.tm.addRow().cell(FOO, (Object)StarWars.LUKE_SKYWALKER);
        this.tm.sort(FOO, TableModel.SortDir.ASC);
        StarWars[] ordered = StarWars.values();
        TableModel.Row[] rows = this.tm.getRows();
        Assert.assertEquals((String)"wrong length?", (long)ordered.length, (long)rows.length);
        int nr = rows.length;
        for (int i = 0; i < nr; ++i) {
            Assert.assertEquals((String)(UNEX_SORT + i), (Object)((Object)ordered[i]), (Object)rows[i].get(FOO));
        }
    }

    private static class ParenFormatter
    implements CellFormatter {
        private ParenFormatter() {
        }

        public String format(Object value) {
            return "(" + value + ")";
        }
    }

    private static enum StarWars {
        LUKE_SKYWALKER,
        LEIA_ORGANA,
        HAN_SOLO,
        C3PO,
        R2D2,
        JABBA_THE_HUTT;

    }
}

