/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.ui.table.cell;

import org.junit.Assert;
import org.junit.Test;
import org.onosproject.ui.table.CellComparator;
import org.onosproject.ui.table.cell.DefaultCellComparator;

public class DefaultCellComparatorTest {
    private static final String SOME = "SoMeStRiNg";
    private static final String OTHER = "OtherSTRING";
    private CellComparator cmp = DefaultCellComparator.INSTANCE;

    @Test
    public void sameString() {
        Assert.assertTrue((String)"same string", (this.cmp.compare((Object)SOME, (Object)SOME) == 0 ? 1 : 0) != 0);
    }

    @Test
    public void someVsOther() {
        Assert.assertTrue((String)"some vs other", (this.cmp.compare((Object)SOME, (Object)OTHER) > 0 ? 1 : 0) != 0);
    }

    @Test
    public void otherVsSome() {
        Assert.assertTrue((String)"other vs some", (this.cmp.compare((Object)OTHER, (Object)SOME) < 0 ? 1 : 0) != 0);
    }

    @Test
    public void someVsNull() {
        Assert.assertTrue((String)"some vs null", (this.cmp.compare((Object)SOME, null) > 0 ? 1 : 0) != 0);
    }

    @Test
    public void nullVsSome() {
        Assert.assertTrue((String)"null vs some", (this.cmp.compare(null, (Object)SOME) < 0 ? 1 : 0) != 0);
    }

    @Test(expected=ClassCastException.class)
    public void mismatch() {
        this.cmp.compare((Object)42, (Object)SOME);
    }

    @Test
    public void strElevenTwo() {
        Assert.assertTrue((String)"str 11 vs 2", (this.cmp.compare((Object)"11", (Object)"2") < 0 ? 1 : 0) != 0);
    }

    @Test
    public void intElevenTwo() {
        Assert.assertTrue((String)"int 11 vs 2", (this.cmp.compare((Object)11, (Object)2) > 0 ? 1 : 0) != 0);
    }

    @Test
    public void intSmallBig() {
        Assert.assertTrue((String)"int 2 vs 4", (this.cmp.compare((Object)2, (Object)4) < 0 ? 1 : 0) != 0);
    }

    @Test
    public void intBigSmall() {
        Assert.assertTrue((String)"int 4 vs 2", (this.cmp.compare((Object)4, (Object)2) > 0 ? 1 : 0) != 0);
    }

    @Test
    public void intEqual() {
        Assert.assertTrue((String)"int 4 vs 4", (this.cmp.compare((Object)4, (Object)4) == 0 ? 1 : 0) != 0);
    }

    @Test
    public void longSmallBig() {
        Assert.assertTrue((String)"long 2 vs 4", (this.cmp.compare((Object)2L, (Object)4L) < 0 ? 1 : 0) != 0);
    }

    @Test
    public void longBigSmall() {
        Assert.assertTrue((String)"long 4 vs 2", (this.cmp.compare((Object)4L, (Object)2L) > 0 ? 1 : 0) != 0);
    }

    @Test
    public void longEqual() {
        Assert.assertTrue((String)"long 4 vs 4", (this.cmp.compare((Object)4L, (Object)4L) == 0 ? 1 : 0) != 0);
    }

    @Test
    public void swEpisodeI() {
        Assert.assertTrue((String)"c3po r2d2", (this.cmp.compare((Object)SmallStarWars.C3PO, (Object)SmallStarWars.R2D2) < 0 ? 1 : 0) != 0);
    }

    @Test
    public void swEpisodeII() {
        Assert.assertTrue((String)"r2d2 c3po", (this.cmp.compare((Object)SmallStarWars.R2D2, (Object)SmallStarWars.C3PO) > 0 ? 1 : 0) != 0);
    }

    @Test
    public void swEpisodeIII() {
        Assert.assertTrue((String)"luke c3po", (this.cmp.compare((Object)SmallStarWars.LUKE, (Object)SmallStarWars.C3PO) > 0 ? 1 : 0) != 0);
    }

    @Test
    public void swEpisodeIV() {
        Assert.assertTrue((String)"c3po luke", (this.cmp.compare((Object)SmallStarWars.C3PO, (Object)SmallStarWars.LUKE) < 0 ? 1 : 0) != 0);
    }

    @Test
    public void swEpisodeV() {
        Assert.assertTrue((String)"luke r2d2", (this.cmp.compare((Object)SmallStarWars.LUKE, (Object)SmallStarWars.R2D2) > 0 ? 1 : 0) != 0);
    }

    @Test
    public void swEpisodeVI() {
        Assert.assertTrue((String)"r2d2 luke", (this.cmp.compare((Object)SmallStarWars.R2D2, (Object)SmallStarWars.LUKE) < 0 ? 1 : 0) != 0);
    }

    private static enum SmallStarWars {
        C3PO,
        R2D2,
        LUKE;

    }
}

