/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.app;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import java.net.URI;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import org.onosproject.app.ApplicationDescription;
import org.onosproject.core.ApplicationRole;
import org.onosproject.core.Permission;
import org.onosproject.core.Version;

public class DefaultApplicationDescription
implements ApplicationDescription {
    private final String name;
    private final Version version;
    private final String description;
    private final String origin;
    private final ApplicationRole role;
    private final Set<Permission> permissions;
    private final Optional<URI> featuresRepo;
    private final List<String> features;

    public DefaultApplicationDescription(String name, Version version, String description, String origin, ApplicationRole role, Set<Permission> permissions, URI featuresRepo, List<String> features) {
        this.name = (String)Preconditions.checkNotNull((Object)name, (Object)"Name cannot be null");
        this.version = (Version)Preconditions.checkNotNull((Object)version, (Object)"Version cannot be null");
        this.description = (String)Preconditions.checkNotNull((Object)description, (Object)"Description cannot be null");
        this.origin = (String)Preconditions.checkNotNull((Object)origin, (Object)"Origin cannot be null");
        this.role = (ApplicationRole)((Object)Preconditions.checkNotNull((Object)((Object)role), (Object)"Role cannot be null"));
        this.permissions = (Set)Preconditions.checkNotNull(permissions, (Object)"Permissions cannot be null");
        this.featuresRepo = Optional.ofNullable(featuresRepo);
        this.features = (List)Preconditions.checkNotNull(features, (Object)"Features cannot be null");
        Preconditions.checkArgument((!features.isEmpty() ? 1 : 0) != 0, (Object)"There must be at least one feature");
    }

    @Override
    public String name() {
        return this.name;
    }

    @Override
    public Version version() {
        return this.version;
    }

    @Override
    public String description() {
        return this.description;
    }

    @Override
    public String origin() {
        return this.origin;
    }

    @Override
    public ApplicationRole role() {
        return this.role;
    }

    @Override
    public Set<Permission> permissions() {
        return this.permissions;
    }

    @Override
    public Optional<URI> featuresRepo() {
        return this.featuresRepo;
    }

    @Override
    public List<String> features() {
        return this.features;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("name", (Object)this.name).add("version", (Object)this.version).add("description", (Object)this.description).add("origin", (Object)this.origin).add("role", (Object)this.role).add("permissions", this.permissions).add("featuresRepo", this.featuresRepo).add("features", this.features).toString();
    }
}

