/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.cluster;

import com.google.common.base.MoreObjects;
import java.util.Objects;
import org.onlab.packet.IpAddress;
import org.onosproject.cluster.ControllerNode;
import org.onosproject.cluster.NodeId;

public class DefaultControllerNode
implements ControllerNode {
    public static final int DEFAULT_PORT = 9876;
    private final NodeId id;
    private final IpAddress ip;
    private final int tcpPort;

    private DefaultControllerNode() {
        this.id = null;
        this.ip = null;
        this.tcpPort = 0;
    }

    public DefaultControllerNode(NodeId id, IpAddress ip) {
        this(id, ip, 9876);
    }

    public DefaultControllerNode(NodeId id, IpAddress ip, int tcpPort) {
        this.id = id;
        this.ip = ip;
        this.tcpPort = tcpPort;
    }

    @Override
    public NodeId id() {
        return this.id;
    }

    @Override
    public IpAddress ip() {
        return this.ip;
    }

    @Override
    public int tcpPort() {
        return this.tcpPort;
    }

    public int hashCode() {
        return Objects.hash(this.id);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o instanceof DefaultControllerNode) {
            DefaultControllerNode that = (DefaultControllerNode)o;
            return Objects.equals(this.id, that.id);
        }
        return false;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("id", (Object)this.id).add("ip", (Object)this.ip).add("tcpPort", this.tcpPort).toString();
    }
}

