/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.cluster;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.joda.time.DateTime;
import org.onosproject.cluster.NodeId;

public class Leadership {
    private final String topic;
    private final Optional<NodeId> leader;
    private final List<NodeId> candidates;
    private final long epoch;
    private final long electedTime;

    public Leadership(String topic, NodeId leader, long epoch, long electedTime) {
        this.topic = topic;
        this.leader = Optional.of(leader);
        this.candidates = ImmutableList.of((Object)leader);
        this.epoch = epoch;
        this.electedTime = electedTime;
    }

    public Leadership(String topic, NodeId leader, List<NodeId> candidates, long epoch, long electedTime) {
        this.topic = topic;
        this.leader = Optional.of(leader);
        this.candidates = ImmutableList.copyOf(candidates);
        this.epoch = epoch;
        this.electedTime = electedTime;
    }

    public Leadership(String topic, List<NodeId> candidates, long epoch, long electedTime) {
        this.topic = topic;
        this.leader = Optional.empty();
        this.candidates = ImmutableList.copyOf(candidates);
        this.epoch = epoch;
        this.electedTime = electedTime;
    }

    public String topic() {
        return this.topic;
    }

    public NodeId leader() {
        return this.leader.orElse(null);
    }

    public List<NodeId> candidates() {
        return this.candidates;
    }

    public long epoch() {
        return this.epoch;
    }

    public long electedTime() {
        return this.electedTime;
    }

    public int hashCode() {
        return Objects.hash(this.topic, this.leader, this.candidates, this.epoch);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof Leadership) {
            Leadership other = (Leadership)obj;
            return Objects.equals(this.topic, other.topic) && Objects.equals(this.epoch, other.epoch);
        }
        return false;
    }

    public String toString() {
        return MoreObjects.toStringHelper(this.getClass()).add("topic", (Object)this.topic).add("leader", this.leader).add("candidates", this.candidates).add("epoch", this.epoch).add("electedTime", (Object)new DateTime(this.electedTime)).toString();
    }
}

