/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.net.driver;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableSet;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.onosproject.net.MutableAnnotations;
import org.onosproject.net.driver.Behaviour;
import org.onosproject.net.driver.Driver;
import org.onosproject.net.driver.DriverData;

public class DefaultDriverData
implements DriverData {
    private final Driver driver;
    private final Map<String, String> properties;

    public DefaultDriverData(Driver driver) {
        this.driver = driver;
        this.properties = new HashMap<String, String>();
    }

    @Override
    public Driver driver() {
        return this.driver;
    }

    @Override
    public <T extends Behaviour> T behaviour(Class<T> behaviourClass) {
        return this.driver.createBehaviour(this, behaviourClass);
    }

    @Override
    public MutableAnnotations set(String key, String value) {
        this.properties.put(key, value);
        return this;
    }

    @Override
    public MutableAnnotations clear(String ... keys) {
        if (keys.length == 0) {
            this.properties.clear();
        } else {
            for (String key : keys) {
                this.properties.remove(key);
            }
        }
        return this;
    }

    @Override
    public Set<String> keys() {
        return ImmutableSet.copyOf(this.properties.keySet());
    }

    @Override
    public String value(String key) {
        return this.properties.get(key);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("type", (Object)this.driver).add("properties", this.properties).toString();
    }
}

