/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.net.driver;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Maps;
import java.util.Map;
import java.util.Set;
import org.onosproject.net.driver.Driver;
import org.onosproject.net.driver.DriverProvider;

public class DefaultDriverProvider
implements DriverProvider {
    protected final Map<String, Driver> drivers = Maps.newConcurrentMap();

    @Override
    public Set<Driver> getDrivers() {
        return ImmutableSet.copyOf(this.drivers.values());
    }

    public void addDrivers(Set<Driver> drivers) {
        drivers.forEach(this::addDriver);
    }

    public void addDriver(Driver driver) {
        Driver ddc = this.drivers.get(driver.name());
        if (ddc == null) {
            this.drivers.put(driver.name(), driver);
        } else {
            this.drivers.put(driver.name(), ddc.merge(driver));
        }
    }

    public void removeDrivers(Set<Driver> drivers) {
        drivers.forEach(this::removeDriver);
    }

    public void removeDriver(Driver driver) {
        this.drivers.remove(driver.name());
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("drivers", this.drivers).toString();
    }
}

