/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.net.flow;

import com.google.common.base.MoreObjects;
import org.onosproject.net.DeviceId;
import org.onosproject.net.flow.DefaultFlowRule;
import org.onosproject.net.flow.FlowEntry;
import org.onosproject.net.flow.FlowRule;
import org.onosproject.net.flow.StoredFlowEntry;
import org.onosproject.net.flow.TrafficSelector;
import org.onosproject.net.flow.TrafficTreatment;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultFlowEntry
extends DefaultFlowRule
implements StoredFlowEntry {
    private static final Logger log = LoggerFactory.getLogger(DefaultFlowEntry.class);
    private long life;
    private long packets;
    private long bytes;
    private FlowEntry.FlowEntryState state;
    private long lastSeen = -1L;
    private final int errType;
    private final int errCode;

    public DefaultFlowEntry(DeviceId deviceId, TrafficSelector selector, TrafficTreatment treatment, int priority, FlowEntry.FlowEntryState state, long life, long packets, long bytes, long flowId, int timeout) {
        super(deviceId, selector, treatment, priority, flowId, timeout, false);
        this.state = state;
        this.life = life;
        this.packets = packets;
        this.bytes = bytes;
        this.errCode = -1;
        this.errType = -1;
        this.lastSeen = System.currentTimeMillis();
    }

    public DefaultFlowEntry(FlowRule rule, FlowEntry.FlowEntryState state, long life, long packets, long bytes) {
        super(rule);
        this.state = state;
        this.life = life;
        this.packets = packets;
        this.bytes = bytes;
        this.errCode = -1;
        this.errType = -1;
        this.lastSeen = System.currentTimeMillis();
    }

    public DefaultFlowEntry(FlowRule rule) {
        super(rule);
        this.state = FlowEntry.FlowEntryState.PENDING_ADD;
        this.life = 0L;
        this.packets = 0L;
        this.bytes = 0L;
        this.errCode = -1;
        this.errType = -1;
        this.lastSeen = System.currentTimeMillis();
    }

    public DefaultFlowEntry(FlowRule rule, int errType, int errCode) {
        super(rule);
        this.state = FlowEntry.FlowEntryState.FAILED;
        this.errType = errType;
        this.errCode = errCode;
        this.lastSeen = System.currentTimeMillis();
    }

    @Override
    public long life() {
        return this.life;
    }

    @Override
    public long packets() {
        return this.packets;
    }

    @Override
    public long bytes() {
        return this.bytes;
    }

    @Override
    public FlowEntry.FlowEntryState state() {
        return this.state;
    }

    @Override
    public long lastSeen() {
        return this.lastSeen;
    }

    @Override
    public void setLastSeen() {
        this.lastSeen = System.currentTimeMillis();
    }

    @Override
    public void setState(FlowEntry.FlowEntryState newState) {
        this.state = newState;
    }

    @Override
    public void setLife(long life) {
        this.life = life;
    }

    @Override
    public void setPackets(long packets) {
        this.packets = packets;
    }

    @Override
    public void setBytes(long bytes) {
        this.bytes = bytes;
    }

    @Override
    public int errType() {
        return this.errType;
    }

    @Override
    public int errCode() {
        return this.errCode;
    }

    @Override
    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("rule", (Object)super.toString()).add("state", (Object)this.state).toString();
    }
}

